/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.type.SqlTypeName;

public class HiveTypeSystemImpl
extends RelDataTypeSystemImpl {
    private static final int MAX_DECIMAL_PRECISION = 38;
    private static final int MAX_DECIMAL_SCALE = 38;
    private static final int DEFAULT_DECIMAL_PRECISION = 10;
    private static final int MAX_CHAR_PRECISION = Integer.MAX_VALUE;
    private static final int DEFAULT_VARCHAR_PRECISION = 65535;
    private static final int DEFAULT_CHAR_PRECISION = 255;
    private static final int MAX_BINARY_PRECISION = Integer.MAX_VALUE;
    private static final int MAX_TIMESTAMP_PRECISION = 9;
    private static final int MAX_TIMESTAMP_WITH_LOCAL_TIME_ZONE_PRECISION = 15;

    public int getMaxScale(SqlTypeName typeName) {
        switch (typeName) {
            case DECIMAL: {
                return this.getMaxNumericScale();
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 9;
            }
        }
        return -1;
    }

    public int getDefaultPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case BINARY: 
            case VARBINARY: 
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.getMaxPrecision(typeName);
            }
            case CHAR: {
                return 255;
            }
            case VARCHAR: {
                return 65535;
            }
            case DECIMAL: {
                return 10;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 2;
            }
        }
        return -1;
    }

    public int getMaxPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case DECIMAL: {
                return this.getMaxNumericPrecision();
            }
            case CHAR: 
            case VARCHAR: {
                return Integer.MAX_VALUE;
            }
            case BINARY: 
            case VARBINARY: {
                return Integer.MAX_VALUE;
            }
            case TIME: 
            case TIMESTAMP: {
                return 9;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return 15;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 10;
            }
        }
        return -1;
    }

    public int getMaxNumericScale() {
        return 38;
    }

    public int getMaxNumericPrecision() {
        return 38;
    }
}

