/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class PrunedPartitionList {
    private final String ppListKey;
    private final Table source;
    private Set<Partition> partitions;
    private List<String> referred;
    private boolean hasUnknowns;

    public PrunedPartitionList(Table source, Set<Partition> partitions, List<String> referred, boolean hasUnknowns) {
        this.source = source;
        this.ppListKey = null;
        this.referred = referred;
        this.partitions = partitions;
        this.hasUnknowns = hasUnknowns;
    }

    public PrunedPartitionList(Table source, String key, Set<Partition> partitions, List<String> referred, boolean hasUnknowns) {
        this.source = source;
        this.ppListKey = key;
        this.referred = referred;
        this.partitions = partitions;
        this.hasUnknowns = hasUnknowns;
    }

    public Table getSourceTable() {
        return this.source;
    }

    public String getKey() {
        return this.ppListKey;
    }

    public Set<Partition> getPartitions() {
        return this.partitions;
    }

    public List<Partition> getNotDeniedPartns() {
        return new ArrayList<Partition>(this.partitions);
    }

    public boolean hasUnknownPartitions() {
        return this.hasUnknowns;
    }

    public List<String> getReferredPartCols() {
        return this.referred;
    }
}

