/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class PathBuilder {
    private ArrayList<String> descendants = new ArrayList();
    private String basePath;

    public PathBuilder(String basePath) {
        this.basePath = basePath;
    }

    public PathBuilder addDescendant(String path) {
        this.descendants.add(path);
        return this;
    }

    public Path build() {
        Path result = new Path(this.basePath);
        for (String descendant : this.descendants) {
            result = new Path(result, descendant);
        }
        return result;
    }

    public static Path fullyQualifiedHDFSUri(Path input, FileSystem hdfsFileSystem) throws SemanticException {
        URI uri = input.toUri();
        String scheme = hdfsFileSystem.getScheme();
        String authority = hdfsFileSystem.getUri().getAuthority();
        String path = uri.getPath();
        try {
            return new Path(new URI(scheme, authority, path, null, null));
        }
        catch (URISyntaxException e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
        }
    }
}

