/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Show Tables", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ShowTablesDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    String pattern;
    String dbName;
    String resFile;
    TableType type;
    private static final String table = "show";
    private static final String schema = "tab_name#string";

    public String getTable() {
        return table;
    }

    public String getSchema() {
        return schema;
    }

    public ShowTablesDesc() {
    }

    public ShowTablesDesc(Path resFile) {
        this.resFile = resFile.toString();
        this.pattern = null;
    }

    public ShowTablesDesc(Path resFile, String dbName) {
        this.resFile = resFile.toString();
        this.dbName = dbName;
    }

    public ShowTablesDesc(Path resFile, String dbName, String pattern) {
        this.resFile = resFile.toString();
        this.dbName = dbName;
        this.pattern = pattern;
    }

    public ShowTablesDesc(Path resFile, String dbName, String pattern, TableType type) {
        this.resFile = resFile.toString();
        this.dbName = dbName;
        this.pattern = pattern;
        this.type = type;
    }

    @Explain(displayName="pattern")
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Explain(displayName="type")
    public TableType getType() {
        return this.type;
    }

    public void setType(TableType type) {
        this.type = type;
    }

    @Explain(displayName="result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFile() {
        return this.resFile;
    }

    public void setResFile(String resFile) {
        this.resFile = resFile;
    }

    @Explain(displayName="database name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }
}

