/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBasePad;

@Description(name="lpad", value="_FUNC_(str, len, pad) - Returns str, left-padded with pad to a length of len", extended="If str is longer than len, the return value is shortened to len characters.\nIn case of empty pad string, the return value is null.\nExample:\n  > SELECT _FUNC_('hi', 5, '??') FROM src LIMIT 1;\n  '???hi'\n  > SELECT _FUNC_('hi', 1, '??') FROM src LIMIT 1;\n  'h'\n  > SELECT _FUNC_('hi', 5, '') FROM src LIMIT 1;\n  null")
public class GenericUDFLpad
extends GenericUDFBasePad {
    public GenericUDFLpad() {
        super("lpad");
    }

    @Override
    protected void performOp(StringBuilder builder, int len, String str, String pad) {
        int pos = Math.max(len - str.length(), 0);
        for (int i = 0; i < pos; i += pad.length()) {
            builder.append(pad);
        }
        builder.setLength(pos);
        builder.append(str, 0, str.length());
        builder.setLength(len);
    }
}

