/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDFReflect;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.util.ReflectionUtils;

@Description(name="reflect", value="_FUNC_(class,method[,arg1[,arg2..]]) calls method with reflection", extended="Use this UDF to call Java methods by matching the argument signature\n")
@UDFType(deterministic=false)
public class GenericUDFReflect
extends AbstractGenericUDFReflect {
    private transient StringObjectInspector inputClassNameOI;
    private transient StringObjectInspector inputMethodNameOI;
    StringObjectInspector classNameOI;
    StringObjectInspector methodNameOI;
    Class<?> c;
    Object o;
    Method m;
    Object className;
    Object methodName;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 2) {
            throw new UDFArgumentLengthException("The function GenericUDFReflect(class,method[,arg1[,arg2]...]) accepts 2 or more arguments.");
        }
        for (int i = 0; i < 2; ++i) {
            if (arguments[i] instanceof StringObjectInspector) continue;
            throw new UDFArgumentTypeException(i, "The first 2 parameters of GenericUDFReflect(class,method[,arg1[,arg2]...]) should be string.");
        }
        this.inputClassNameOI = (StringObjectInspector)arguments[0];
        this.inputMethodNameOI = (StringObjectInspector)arguments[1];
        this.classNameOI = (StringObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)arguments[0]);
        this.methodNameOI = (StringObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)arguments[1]);
        this.setupParameterOIs(arguments, 2);
        return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        boolean classNameChanged = false;
        Object newClassName = arguments[0].get();
        if (this.className == null || ObjectInspectorUtils.compare((Object)this.className, (ObjectInspector)this.classNameOI, (Object)newClassName, (ObjectInspector)this.inputClassNameOI) != 0) {
            this.className = ObjectInspectorUtils.copyToStandardObject((Object)newClassName, (ObjectInspector)this.inputClassNameOI);
            String classNameString = this.classNameOI.getPrimitiveJavaObject(this.className);
            try {
                this.c = JavaUtils.loadClass((String)classNameString);
            }
            catch (ClassNotFoundException ex) {
                throw new HiveException("UDFReflect evaluate ", ex);
            }
            try {
                this.o = null;
                this.o = ReflectionUtils.newInstance(this.c, null);
            }
            catch (Exception ex) {
                // empty catch block
            }
            classNameChanged = true;
        }
        Object newMethodName = arguments[1].get();
        if (this.methodName == null || ObjectInspectorUtils.compare((Object)this.methodName, (ObjectInspector)this.methodNameOI, (Object)newMethodName, (ObjectInspector)this.inputMethodNameOI) != 0 || classNameChanged) {
            this.methodName = ObjectInspectorUtils.copyToStandardObject((Object)newMethodName, (ObjectInspector)this.inputMethodNameOI);
            String methodNameString = this.methodNameOI.getPrimitiveJavaObject(this.methodName);
            try {
                this.m = this.findMethod(this.c, methodNameString, String.class, false);
            }
            catch (Exception e) {
                throw new HiveException("UDFReflect getMethod ", e);
            }
        }
        Object[] parameterJavaValues = this.setupParameters(arguments, 2);
        try {
            return String.valueOf(this.m.invoke(this.o, parameterJavaValues));
        }
        catch (Exception e1) {
            System.err.println("UDFReflect evaluate " + e1 + " method = " + this.m + " args = " + Arrays.asList(parameterJavaValues));
            return null;
        }
    }

    @Override
    protected String functionName() {
        return "reflect";
    }
}

