/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableTimestampLocalTZObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Description(name="timestamp with local time zone", value="CAST(STRING as TIMESTAMP WITH LOCAL TIME ZONE) - returns thetimestamp with local time zone represented by string.", extended="The string should be of format 'yyyy-MM-dd HH:mm:ss[.SSS...] ZoneId/ZoneOffset'. Examples of ZoneId and ZoneOffset are Asia/Shanghai and GMT+08:00. The time and zone parts are optional. If time is absent, '00:00:00.0' will be used. If zone is absent, the system time zone will be used.")
public class GenericUDFToTimestampLocalTZ
extends GenericUDF
implements SettableUDF {
    private transient PrimitiveObjectInspector argumentOI;
    private transient PrimitiveObjectInspectorConverter.TimestampLocalTZConverter converter;
    private TimestampLocalTZTypeInfo typeInfo;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1) {
            throw new UDFArgumentLengthException("The function CAST as TIMESTAMP WITH LOCAL TIME ZONE requires at least one argument, got " + arguments.length);
        }
        try {
            this.argumentOI = (PrimitiveObjectInspector)arguments[0];
            switch (this.argumentOI.getPrimitiveCategory()) {
                case CHAR: 
                case VARCHAR: 
                case STRING: 
                case DATE: 
                case TIMESTAMP: 
                case TIMESTAMPLOCALTZ: {
                    break;
                }
                default: {
                    throw new UDFArgumentException("CAST as TIMESTAMP WITH LOCAL TIME ZONE only allowsstring/date/timestamp/timestamp with time zone types");
                }
            }
        }
        catch (ClassCastException e) {
            throw new UDFArgumentException("The function CAST as TIMESTAMP WITH LOCAL TIME ZONE takes only primitive types");
        }
        SettableTimestampLocalTZObjectInspector outputOI = (SettableTimestampLocalTZObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)this.typeInfo);
        this.converter = new PrimitiveObjectInspectorConverter.TimestampLocalTZConverter(this.argumentOI, outputOI);
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object o0 = arguments[0].get();
        if (o0 == null) {
            return null;
        }
        return this.converter.convert(o0);
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        StringBuilder sb = new StringBuilder();
        sb.append("CAST( ");
        sb.append(children[0]);
        sb.append(" AS ");
        sb.append(this.typeInfo.getTypeName());
        sb.append(")");
        return sb.toString();
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    @Override
    public void setTypeInfo(TypeInfo typeInfo) throws UDFArgumentException {
        this.typeInfo = (TimestampLocalTZTypeInfo)typeInfo;
    }
}

