/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.udf.generic.MaskTransformer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

class MaskLastNTransformer
extends MaskTransformer {
    int charCount = 4;

    @Override
    public void init(ObjectInspector[] arguments, int argsStartIdx) {
        super.init(arguments, argsStartIdx + 1);
        this.charCount = this.getIntArg(arguments, argsStartIdx, 4);
        if (this.charCount < 0) {
            this.charCount = 0;
        }
    }

    @Override
    String transform(String value) {
        int i;
        StringBuilder ret = new StringBuilder(value.length());
        int startIdx = value.length() <= this.charCount ? 0 : value.length() - this.charCount;
        for (i = 0; i < startIdx; ++i) {
            ret.appendCodePoint(value.charAt(i));
        }
        for (i = startIdx; i < value.length(); ++i) {
            ret.appendCodePoint(this.transformChar(value.charAt(i)));
        }
        return ret.toString();
    }

    @Override
    Byte transform(Byte value) {
        byte val = value;
        if (value < 0) {
            val = (byte)(val * -1);
        }
        byte ret = 0;
        int pos = 1;
        int i = 0;
        while (val != 0) {
            ret = i < this.charCount ? (byte)(ret + this.maskedNumber * pos) : (byte)(ret + val % 10 * pos);
            val = (byte)(val / 10);
            pos *= 10;
            ++i;
        }
        if (value < 0) {
            ret = (byte)(ret * -1);
        }
        return ret;
    }

    @Override
    Short transform(Short value) {
        short val = value;
        if (value < 0) {
            val = (short)(val * -1);
        }
        short ret = 0;
        int pos = 1;
        int i = 0;
        while (val != 0) {
            ret = i < this.charCount ? (short)(ret + this.maskedNumber * pos) : (short)(ret + val % 10 * pos);
            val = (short)(val / 10);
            pos *= 10;
            ++i;
        }
        if (value < 0) {
            ret = (short)(ret * -1);
        }
        return ret;
    }

    @Override
    Integer transform(Integer value) {
        int val = value;
        if (value < 0) {
            val *= -1;
        }
        int ret = 0;
        int pos = 1;
        int i = 0;
        while (val != 0) {
            ret = i < this.charCount ? (ret += this.maskedNumber * pos) : (ret += val % 10 * pos);
            val /= 10;
            pos *= 10;
            ++i;
        }
        if (value < 0) {
            ret *= -1;
        }
        return ret;
    }

    @Override
    Long transform(Long value) {
        long val = value;
        if (value < 0L) {
            val *= -1L;
        }
        long ret = 0L;
        long pos = 1L;
        int i = 0;
        while (val != 0L) {
            ret = i < this.charCount ? (ret += (long)this.maskedNumber * pos) : (ret += val % 10L * pos);
            val /= 10L;
            pos *= 10L;
            ++i;
        }
        if (value < 0L) {
            ret *= -1L;
        }
        return ret;
    }
}

