/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.HostPort;

public class InputHost
extends HostPort {
    private String additionalInfo;
    private final Map<PartitionRange, BlockingQueue<InputAttemptIdentifier>> partitionToInputs = new ConcurrentHashMap<PartitionRange, BlockingQueue<InputAttemptIdentifier>>();

    public InputHost(HostPort hostPort) {
        super(hostPort.getHost(), hostPort.getPort());
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo == null ? "" : this.additionalInfo;
    }

    public int getNumPendingPartitions() {
        return this.partitionToInputs.size();
    }

    public synchronized void addKnownInput(int partition, int partitionCount, InputAttemptIdentifier srcAttempt) {
        PartitionRange partitionRange = new PartitionRange(partition, partitionCount);
        BlockingQueue<InputAttemptIdentifier> inputs = this.partitionToInputs.get(partitionRange);
        if (inputs == null) {
            inputs = new LinkedBlockingQueue<InputAttemptIdentifier>();
            this.partitionToInputs.put(partitionRange, inputs);
        }
        inputs.add(srcAttempt);
    }

    public synchronized PartitionToInputs clearAndGetOnePartitionRange() {
        Iterator<Map.Entry<PartitionRange, BlockingQueue<InputAttemptIdentifier>>> iterator = this.partitionToInputs.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<PartitionRange, BlockingQueue<InputAttemptIdentifier>> entry = iterator.next();
            ArrayList<InputAttemptIdentifier> inputs = new ArrayList<InputAttemptIdentifier>(entry.getValue().size());
            entry.getValue().drainTo(inputs);
            PartitionToInputs ret = new PartitionToInputs(entry.getKey().getPartition(), entry.getKey().getPartitionCount(), inputs);
            this.partitionToInputs.remove(entry.getKey());
            return ret;
        }
        return null;
    }

    public String toDetailedString() {
        return "HostPort=" + super.toString() + ", InputDetails=" + this.partitionToInputs;
    }

    @Override
    public String toString() {
        return "HostPort=" + super.toString() + ", PartitionIds=" + this.partitionToInputs.keySet();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object to) {
        return super.equals(to);
    }

    public static class PartitionToInputs {
        private final int partition;
        private final int partitionCount;
        private List<InputAttemptIdentifier> inputs;

        public PartitionToInputs(int partition, int partitionCount, List<InputAttemptIdentifier> input) {
            this.partition = partition;
            this.partitionCount = partitionCount;
            this.inputs = input;
        }

        public int getPartition() {
            return this.partition;
        }

        public int getPartitionCount() {
            return this.partitionCount;
        }

        public List<InputAttemptIdentifier> getInputs() {
            return this.inputs;
        }

        public String toString() {
            return "partition=" + this.partition + ", partitionCount=" + this.partitionCount + ", inputs=" + this.inputs;
        }
    }

    private static class PartitionRange {
        private final int partition;
        private final int partitionCount;

        PartitionRange(int partition, int partitionCount) {
            this.partition = partition;
            this.partitionCount = partitionCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionRange that = (PartitionRange)o;
            if (this.partition != that.partition) {
                return false;
            }
            return this.partitionCount == that.partitionCount;
        }

        public int hashCode() {
            int result = this.partition;
            result = 31 * result + this.partitionCount;
            return result;
        }

        public int getPartition() {
            return this.partition;
        }

        public int getPartitionCount() {
            return this.partitionCount;
        }
    }
}

