/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.CloneInfo;
import org.apache.accumulo.master.tableOps.FinishCloneTable;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.slf4j.LoggerFactory;

class CloneMetadata
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private CloneInfo cloneInfo;

    public CloneMetadata(CloneInfo cloneInfo) {
        this.cloneInfo = cloneInfo;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        LoggerFactory.getLogger(CloneMetadata.class).info(String.format("Cloning %s with tableId %s from srcTableId %s", this.cloneInfo.tableName, this.cloneInfo.tableId, this.cloneInfo.srcTableId));
        MetadataTableUtil.deleteTable((String)this.cloneInfo.tableId, (boolean)false, (ClientContext)environment, (ZooLock)environment.getMasterLock());
        MetadataTableUtil.cloneTable((ClientContext)environment, (String)this.cloneInfo.srcTableId, (String)this.cloneInfo.tableId, (VolumeManager)environment.getFileSystem());
        return new FinishCloneTable(this.cloneInfo);
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        MetadataTableUtil.deleteTable((String)this.cloneInfo.tableId, (boolean)false, (ClientContext)environment, (ZooLock)environment.getMasterLock());
    }
}

