/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.tables.TableManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NamespaceCleanUp
extends MasterRepo {
    private static final Logger log = LoggerFactory.getLogger(NamespaceCleanUp.class);
    private static final long serialVersionUID = 1L;
    private String namespaceId;

    public NamespaceCleanUp(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    public long isReady(long tid, Master master) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long id, Master master) throws Exception {
        try {
            TableManager.getInstance().removeNamespace(this.namespaceId);
        }
        catch (Exception e) {
            log.error("Failed to find namespace in zookeeper", (Throwable)e);
        }
        Tables.clearCache((Instance)master.getInstance());
        try {
            AuditedSecurityOperation.getInstance((AccumuloServerContext)master).deleteNamespace(master.rpcCreds(), this.namespaceId);
        }
        catch (ThriftSecurityException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
        }
        Utils.unreserveNamespace(this.namespaceId, id, true);
        log.debug("Deleted namespace " + this.namespaceId);
        return null;
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
    }
}

