/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.hiverc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyArray;
import org.apache.hadoop.hive.serde2.lazy.LazyBoolean;
import org.apache.hadoop.hive.serde2.lazy.LazyByte;
import org.apache.hadoop.hive.serde2.lazy.LazyDouble;
import org.apache.hadoop.hive.serde2.lazy.LazyFloat;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.lazy.LazyMap;
import org.apache.hadoop.hive.serde2.lazy.LazyShort;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.pig.data.InternalMap;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class HiveRCSchemaUtil {
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();
    protected static final Pattern ptypes = Pattern.compile("([ ][a-zA-Z0-9]*)|([a-zA-Z_0-9]*[<][a-zA-Z,_0-9]*[>])");

    public static List<String> parseSchema(Pattern pattern, String schema) {
        ArrayList<String> types = new ArrayList<String>();
        Matcher m = pattern.matcher(schema);
        String item = null;
        while (m.find()) {
            item = m.group().trim();
            if (item.length() <= 0) continue;
            types.add(item);
        }
        return types;
    }

    public static List<String> parseSchemaTypes(String schema) {
        ArrayList<String> types = new ArrayList<String>();
        Matcher m = ptypes.matcher(schema);
        String item = null;
        while (m.find()) {
            item = m.group().trim();
            if (item.length() <= 0) continue;
            if (item.equalsIgnoreCase("map")) {
                if (m.find()) {
                    types.add(item + m.group().trim());
                    continue;
                }
                throw new RuntimeException("Map must have generic types specified");
            }
            if (item.equalsIgnoreCase("array")) {
                if (m.find()) {
                    types.add(item + m.group().trim());
                    continue;
                }
                throw new RuntimeException("Array must have generic types specified");
            }
            types.add(item);
        }
        return types;
    }

    public static final String listToString(List<String> list) {
        StringBuilder buff = new StringBuilder();
        for (String item : list) {
            buff.append(item.trim()).append(",");
        }
        int len = buff.length() - 1;
        buff.delete(len, len);
        return buff.toString();
    }

    public static final String extractDayDate(String fileName) {
        int index = fileName.indexOf("daydate=");
        String dateStr = null;
        if (index == 0) {
            dateStr = fileName.substring(8, fileName.length());
        } else if (index > 0) {
            dateStr = fileName.substring(index + 8, fileName.indexOf(47, index));
        }
        return dateStr;
    }

    public static final Set<String> compileSet(String columnsToRead) {
        String[] columnsArr = columnsToRead.split(",");
        int len = columnsArr.length;
        TreeSet<String> columnsSet = new TreeSet<String>();
        for (int i = 0; i < len; ++i) {
            columnsSet.add(columnsArr[i].trim());
        }
        return columnsSet;
    }

    public static byte findPigDataType(String hiveType) {
        if ((hiveType = hiveType.toLowerCase()).equals("string")) {
            return 55;
        }
        if (hiveType.equals("int")) {
            return 10;
        }
        if (hiveType.equals("bigint") || hiveType.equals("long")) {
            return 15;
        }
        if (hiveType.equals("float")) {
            return 20;
        }
        if (hiveType.equals("double")) {
            return 25;
        }
        if (hiveType.equals("boolean")) {
            return 5;
        }
        if (hiveType.equals("byte")) {
            return 10;
        }
        if (hiveType.contains("array")) {
            return 110;
        }
        if (hiveType.contains("map")) {
            return 100;
        }
        return -1;
    }

    public static Object extractPigTypeFromHiveType(Object value) {
        if (value instanceof LazyArray) {
            value = HiveRCSchemaUtil.parseLazyArrayToPigArray((LazyArray)value);
        } else if (value instanceof LazyMap) {
            value = HiveRCSchemaUtil.parseLazyMapToPigMap((LazyMap)value);
        } else if (value instanceof LazyString) {
            value = ((Text)((LazyString)value).getWritableObject()).toString();
        } else if (value instanceof LazyInteger) {
            value = ((IntWritable)((LazyInteger)value).getWritableObject()).get();
        } else if (value instanceof LazyLong) {
            value = ((LongWritable)((LazyLong)value).getWritableObject()).get();
        } else if (value instanceof LazyFloat) {
            value = Float.valueOf(((FloatWritable)((LazyFloat)value).getWritableObject()).get());
        } else if (value instanceof LazyDouble) {
            value = ((DoubleWritable)((LazyDouble)value).getWritableObject()).get();
        } else if (value instanceof LazyBoolean) {
            boolean boolvalue = ((BooleanWritable)((LazyBoolean)value).getWritableObject()).get();
            value = boolvalue ? 1 : 0;
        } else if (value instanceof LazyByte) {
            value = (int)((ByteWritable)((LazyByte)value).getWritableObject()).get();
        } else if (value instanceof LazyShort) {
            value = ((ShortWritable)((LazyShort)value).getWritableObject()).get();
        }
        return value;
    }

    public static InternalMap parseLazyMapToPigMap(LazyMap map) {
        InternalMap pigmap = new InternalMap();
        Map javamap = map.getMap();
        if (javamap != null) {
            for (Map.Entry entry : javamap.entrySet()) {
                pigmap.put(HiveRCSchemaUtil.extractPigTypeFromHiveType(entry.getKey()), HiveRCSchemaUtil.extractPigTypeFromHiveType(entry.getValue()));
            }
        }
        return pigmap;
    }

    public static Tuple parseLazyArrayToPigArray(LazyArray arr) {
        ArrayList<Object> list = new ArrayList<Object>();
        List hivedataList = arr.getList();
        for (Object item : hivedataList) {
            list.add(HiveRCSchemaUtil.extractPigTypeFromHiveType(item));
        }
        return tupleFactory.newTuple(list);
    }
}

