/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga;

import java.io.Serializable;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

public class FpgaDevice
implements Serializable {
    private static final long serialVersionUID = -4678487141824092751L;
    private final String type;
    private final int major;
    private final int minor;
    private final String aliasDevName;
    private String IPID;
    private String aocxHash;
    private Integer hashCode;

    public String getType() {
        return this.type;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getIPID() {
        return this.IPID;
    }

    public String getAocxHash() {
        return this.aocxHash;
    }

    public void setAocxHash(String hash) {
        this.aocxHash = hash;
    }

    public void setIPID(String IPID) {
        this.IPID = IPID;
    }

    public String getAliasDevName() {
        return this.aliasDevName;
    }

    public FpgaDevice(String type, int major, int minor, String aliasDevName) {
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type must not be null");
        this.major = major;
        this.minor = minor;
        this.aliasDevName = (String)Preconditions.checkNotNull((Object)aliasDevName, (Object)"aliasDevName must not be null");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FpgaDevice other = (FpgaDevice)obj;
        if (this.aliasDevName == null ? other.aliasDevName != null : !this.aliasDevName.equals(other.aliasDevName)) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.major;
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.minor;
            result = 31 * result + this.aliasDevName.hashCode();
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        return "FPGA Device:(Type: " + this.type + ", Major: " + this.major + ", Minor: " + this.minor + ", IPID: " + this.IPID + ", Hash: " + this.aocxHash + ")";
    }
}

