/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.client;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.tez.mapreduce.client.ClientServiceDelegate;
import org.apache.tez.mapreduce.client.ResourceMgrDelegate;

public class ClientCache {
    private final Configuration conf;
    private final ResourceMgrDelegate rm;
    private Map<JobID, ClientServiceDelegate> cache = new HashMap<JobID, ClientServiceDelegate>();

    public ClientCache(Configuration conf, ResourceMgrDelegate rm) {
        this.conf = conf;
        this.rm = rm;
    }

    public synchronized ClientServiceDelegate getClient(JobID jobId) {
        ClientServiceDelegate client = this.cache.get(jobId);
        if (client == null) {
            client = new ClientServiceDelegate(this.conf, this.rm, jobId);
            this.cache.put(jobId, client);
        }
        return client;
    }
}

