/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DeallocateRewriteByteBuffAllocator
extends ByteBuffAllocator {
    private static final Logger LOG = LoggerFactory.getLogger(DeallocateRewriteByteBuffAllocator.class);

    DeallocateRewriteByteBuffAllocator(boolean reservoirEnabled, int maxBufCount, int bufSize, int minSizeForReservoirUse) {
        super(reservoirEnabled, maxBufCount, bufSize, minSizeForReservoirUse);
    }

    @Override
    protected void putbackBuffer(ByteBuffer buf) {
        if (buf.capacity() != this.bufSize || this.reservoirEnabled ^ buf.isDirect()) {
            LOG.warn("Trying to put a buffer, not created by this pool! Will be just ignored");
            return;
        }
        buf.clear();
        byte[] tmp = this.generateTmpBytes(buf.capacity());
        buf.put(tmp, 0, tmp.length);
        super.putbackBuffer(buf);
    }

    private byte[] generateTmpBytes(int length) {
        StringBuilder result = new StringBuilder();
        while (result.length() < length) {
            result.append("-");
        }
        return Bytes.toBytes(result.substring(0, length));
    }
}

