/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import com.google.common.base.Predicate;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooConfiguration
extends AccumuloConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ZooConfiguration.class);
    private final ZooCache propCache;
    private final AccumuloConfiguration parent;
    private final Map<String, String> fixedProps = Collections.synchronizedMap(new HashMap());
    private final String propPathPrefix;

    protected ZooConfiguration(String instanceId, ZooCache propCache, AccumuloConfiguration parent) {
        this.propCache = propCache;
        this.parent = parent;
        this.propPathPrefix = ZooUtil.getRoot((String)instanceId) + "/config";
    }

    public void invalidateCache() {
        if (this.propCache != null) {
            this.propCache.clear();
        }
    }

    public AccumuloConfiguration getParentConfiguration() {
        return this.parent;
    }

    private String _get(Property property) {
        String key = property.getKey();
        String value = null;
        if (Property.isValidZooPropertyKey((String)key)) {
            value = this.getRaw(key);
        }
        if (value == null || !property.getType().isValidFormat(value)) {
            if (value != null) {
                log.error("Using parent value for " + key + " due to improperly formatted " + property.getType() + ": " + value);
            }
            value = this.parent.get(property);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Property property) {
        if (Property.isFixedZooPropertyKey((Property)property)) {
            if (this.fixedProps.containsKey(property.getKey())) {
                return this.fixedProps.get(property.getKey());
            }
            Map<String, String> map = this.fixedProps;
            synchronized (map) {
                String val = this._get(property);
                this.fixedProps.put(property.getKey(), val);
                return val;
            }
        }
        return this._get(property);
    }

    private String getRaw(String key) {
        String zPath = this.propPathPrefix + "/" + key;
        byte[] v = this.propCache.get(zPath);
        String value = null;
        if (v != null) {
            value = new String(v, StandardCharsets.UTF_8);
        }
        return value;
    }

    public void getProperties(Map<String, String> props, Predicate<String> filter) {
        this.parent.getProperties(props, filter);
        List children = this.propCache.getChildren(this.propPathPrefix);
        if (children != null) {
            for (String child : children) {
                String value;
                if (child == null || !filter.apply((Object)child) || (value = this.getRaw(child)) == null) continue;
                props.put(child, value);
            }
        }
    }

    public long getUpdateCount() {
        return this.parent.getUpdateCount() + this.propCache.getUpdateCount();
    }
}

