/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.llap.FieldDesc;
import org.apache.hadoop.io.Writable;

public class Schema
implements Writable {
    private final List<FieldDesc> columns;

    public Schema(List<FieldDesc> columns) {
        this.columns = columns;
    }

    public Schema() {
        this.columns = new ArrayList<FieldDesc>();
    }

    public List<FieldDesc> getColumns() {
        return this.columns;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (FieldDesc colDesc : this.getColumns()) {
            if (!first) {
                sb.append(",");
            }
            sb.append(colDesc.toString());
            first = false;
        }
        return sb.toString();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.columns.size());
        for (FieldDesc column : this.columns) {
            column.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numColumns = in.readInt();
        this.columns.clear();
        for (int idx = 0; idx < numColumns; ++idx) {
            FieldDesc colDesc = new FieldDesc();
            colDesc.readFields(in);
            this.columns.add(colDesc);
        }
    }
}

