/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.tez.common.TezLocalResource;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.internals.api.events.SystemEventProtos;

public final class TezConverterUtils {
    private TezConverterUtils() {
    }

    @InterfaceAudience.Private
    public static URI getURIFromYarnURL(URL url) throws URISyntaxException {
        String scheme = url.getScheme() == null ? "" : url.getScheme();
        String authority = "";
        if (url.getHost() != null) {
            authority = url.getHost();
            if (url.getUserInfo() != null) {
                authority = url.getUserInfo() + "@" + authority;
            }
            if (url.getPort() > 0) {
                authority = authority + ":" + url.getPort();
            }
        }
        return new URI(scheme, authority, url.getFile(), null, null).normalize();
    }

    @InterfaceAudience.Private
    public static TezLocalResource convertYarnLocalResourceToTez(LocalResource lr) throws URISyntaxException {
        return new TezLocalResource(TezConverterUtils.getURIFromYarnURL(lr.getResource()), lr.getSize(), lr.getTimestamp());
    }

    public static TaskFailureType failureTypeFromProto(SystemEventProtos.TaskFailureTypeProto proto) {
        switch (proto) {
            case FT_NON_FATAL: {
                return TaskFailureType.NON_FATAL;
            }
            case FT_FATAL: {
                return TaskFailureType.FATAL;
            }
        }
        throw new TezUncheckedException("Unknown FailureTypeProto: " + (Object)((Object)proto));
    }

    public static SystemEventProtos.TaskFailureTypeProto failureTypeToProto(TaskFailureType taskFailureType) {
        switch (taskFailureType) {
            case NON_FATAL: {
                return SystemEventProtos.TaskFailureTypeProto.FT_NON_FATAL;
            }
            case FATAL: {
                return SystemEventProtos.TaskFailureTypeProto.FT_FATAL;
            }
        }
        throw new TezUncheckedException("Unknown FailureType: " + taskFailureType);
    }
}

