/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.server.resourcemanager.placement.DefaultPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.FSPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PrimaryGroupPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.RejectPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.SecondaryGroupExistingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.SpecifiedPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigRuleHandler;

class QueuePlacementConverter {
    private static final String USER = "%user";
    private static final String PRIMARY_GROUP = "%primary_group";
    private static final String SECONDARY_GROUP = "%secondary_group";
    private static final String RULE_SEPARATOR = ",";

    QueuePlacementConverter() {
    }

    Map<String, String> convertPlacementPolicy(PlacementManager placementManager, FSConfigToCSConfigRuleHandler ruleHandler, boolean userAsDefaultQueue) {
        StringBuilder mapping = new StringBuilder();
        HashMap<String, String> properties = new HashMap<String, String>();
        if (userAsDefaultQueue) {
            mapping.append("u:%user:%user");
        }
        int ruleCount = 0;
        for (PlacementRule rule : placementManager.getPlacementRules()) {
            if (((FSPlacementRule)rule).getCreateFlag()) {
                ruleHandler.handleQueueAutoCreate(rule.getName());
            }
            ++ruleCount;
            if (rule instanceof UserPlacementRule) {
                UserPlacementRule userRule = (UserPlacementRule)rule;
                if (userRule.getParentRule() != null) {
                    this.handleNestedRule(mapping, userRule, ruleHandler);
                    continue;
                }
                if (userAsDefaultQueue) continue;
                if (mapping.length() > 0) {
                    mapping.append(RULE_SEPARATOR);
                }
                mapping.append("u:%user:%user");
                continue;
            }
            if (rule instanceof SpecifiedPlacementRule) {
                if (ruleCount > 1) {
                    ruleHandler.handleSpecifiedNotFirstRule();
                }
                properties.put("yarn.scheduler.capacity.queue-mappings-override.enable", "false");
                continue;
            }
            if (rule instanceof PrimaryGroupPlacementRule) {
                if (mapping.length() > 0) {
                    mapping.append(RULE_SEPARATOR);
                }
                mapping.append("u:%user:%primary_group");
                continue;
            }
            if (rule instanceof DefaultPlacementRule) {
                DefaultPlacementRule defaultRule = (DefaultPlacementRule)rule;
                if (mapping.length() > 0) {
                    mapping.append(RULE_SEPARATOR);
                }
                mapping.append("u:%user:").append(defaultRule.defaultQueueName);
                continue;
            }
            if (rule instanceof SecondaryGroupExistingPlacementRule) {
                if (mapping.length() > 0) {
                    mapping.append(RULE_SEPARATOR);
                }
                mapping.append("u:%user:%secondary_group");
                continue;
            }
            if (rule instanceof RejectPlacementRule) continue;
            throw new IllegalArgumentException("Unknown placement rule: " + rule);
        }
        if (mapping.length() > 0) {
            properties.put("yarn.scheduler.capacity.queue-mappings", mapping.toString());
        }
        return properties;
    }

    private void handleNestedRule(StringBuilder mapping, UserPlacementRule userRule, FSConfigToCSConfigRuleHandler ruleHandler) {
        PlacementRule pr = userRule.getParentRule();
        if (mapping.length() > 0) {
            mapping.append(RULE_SEPARATOR);
        }
        if (pr instanceof PrimaryGroupPlacementRule) {
            String mappingString = "u:%user:%primary_group.%user";
            ruleHandler.handleDynamicMappedQueue(mappingString, ((PrimaryGroupPlacementRule)pr).getCreateFlag());
            mapping.append(mappingString);
        } else if (pr instanceof SecondaryGroupExistingPlacementRule) {
            String mappingString = "u:%user:%secondary_group.%user";
            ruleHandler.handleDynamicMappedQueue(mappingString, ((SecondaryGroupExistingPlacementRule)pr).getCreateFlag());
            mapping.append("u:%user:%secondary_group.%user");
        } else if (pr instanceof DefaultPlacementRule) {
            DefaultPlacementRule defaultRule = (DefaultPlacementRule)pr;
            String mappingString = "u:%user:" + defaultRule.defaultQueueName + "." + USER;
            ruleHandler.handleDynamicMappedQueue(mappingString, defaultRule.getCreateFlag());
            mapping.append(mappingString);
        } else {
            throw new UnsupportedOperationException("Unsupported nested rule: " + pr.getClass().getCanonicalName());
        }
    }
}

