/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestInterfaceAlign {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestInterfaceAlign.class);

    @Test
    public void testAdminWithAsyncAdmin() {
        List<String> adminMethodNames = this.getMethodNames(Admin.class);
        List<String> asyncAdminMethodNames = this.getMethodNames(AsyncAdmin.class);
        adminMethodNames.remove("getOperationTimeout");
        adminMethodNames.remove("getSyncWaitTimeout");
        adminMethodNames.remove("getConnection");
        adminMethodNames.remove("getConfiguration");
        adminMethodNames.removeAll(this.getMethodNames(Abortable.class));
        adminMethodNames.removeAll(this.getMethodNames(Closeable.class));
        adminMethodNames.forEach(method -> {
            boolean contains = asyncAdminMethodNames.contains(method);
            if (method.endsWith("Async")) {
                contains = asyncAdminMethodNames.contains(method.replace("Async", ""));
            }
            Assert.assertTrue((String)("Admin method " + method + " should in AsyncAdmin too"), (boolean)contains);
        });
        asyncAdminMethodNames.forEach(method -> {
            boolean contains = adminMethodNames.contains(method);
            if (!contains) {
                contains = adminMethodNames.contains(method + "Async");
            }
            Assert.assertTrue((String)("AsyncAdmin method " + method + " should in Admin too"), (boolean)contains);
        });
    }

    private <T> List<String> getMethodNames(Class<T> c) {
        return Arrays.asList(c.getMethods()).stream().filter(m -> !this.isDeprecated((Method)m)).filter(m -> !Modifier.isStatic(m.getModifiers())).map(Method::getName).distinct().collect(Collectors.toList());
    }

    private boolean isDeprecated(Method method) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getDeclaredAnnotations()) {
            if (!(annotation instanceof Deprecated)) continue;
            return true;
        }
        return false;
    }
}

