/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.quotas.SpaceLimitSettings;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSpaceLimitSettings {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSpaceLimitSettings.class);

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidTableQuotaSizeLimit() {
        new SpaceLimitSettings(TableName.valueOf((String)"foo"), -1L, SpaceViolationPolicy.NO_INSERTS);
    }

    @Test(expected=NullPointerException.class)
    public void testNullTableName() {
        TableName tn = null;
        new SpaceLimitSettings(tn, 1L, SpaceViolationPolicy.NO_INSERTS);
    }

    @Test(expected=NullPointerException.class)
    public void testNullTableViolationPolicy() {
        new SpaceLimitSettings(TableName.valueOf((String)"foo"), 1L, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNamespaceQuotaSizeLimit() {
        new SpaceLimitSettings("foo_ns", -1L, SpaceViolationPolicy.NO_INSERTS);
    }

    @Test(expected=NullPointerException.class)
    public void testNullNamespace() {
        String ns = null;
        new SpaceLimitSettings(ns, 1L, SpaceViolationPolicy.NO_INSERTS);
    }

    @Test(expected=NullPointerException.class)
    public void testNullNamespaceViolationPolicy() {
        new SpaceLimitSettings("foo_ns", 1L, null);
    }

    @Test
    public void testTableQuota() {
        TableName tableName = TableName.valueOf((String)"foo");
        long sizeLimit = 0x100000L;
        SpaceViolationPolicy policy = SpaceViolationPolicy.NO_WRITES;
        SpaceLimitSettings settings = new SpaceLimitSettings(tableName, 0x100000L, policy);
        MasterProtos.SetQuotaRequest proto = QuotaSettings.buildSetQuotaRequestProto((QuotaSettings)settings);
        Assert.assertFalse((String)"User should be missing", (boolean)proto.hasUserName());
        Assert.assertFalse((String)"Namespace should be missing", (boolean)proto.hasNamespace());
        Assert.assertEquals((Object)ProtobufUtil.toProtoTableName((TableName)tableName), (Object)proto.getTableName());
        QuotaProtos.SpaceLimitRequest spaceLimitReq = proto.getSpaceLimit();
        Assert.assertNotNull((String)"SpaceLimitRequest was null", (Object)spaceLimitReq);
        QuotaProtos.SpaceQuota spaceQuota = spaceLimitReq.getQuota();
        Assert.assertNotNull((String)"SpaceQuota was null", (Object)spaceQuota);
        Assert.assertEquals((long)0x100000L, (long)spaceQuota.getSoftLimit());
        Assert.assertEquals((Object)ProtobufUtil.toProtoViolationPolicy((SpaceViolationPolicy)policy), (Object)spaceQuota.getViolationPolicy());
        Assert.assertEquals((Object)QuotaType.SPACE, (Object)settings.getQuotaType());
        SpaceLimitSettings copy = new SpaceLimitSettings(tableName, 0x100000L, policy);
        Assert.assertEquals((Object)settings, (Object)copy);
        Assert.assertEquals((long)settings.hashCode(), (long)copy.hashCode());
    }

    @Test
    public void testNamespaceQuota() {
        String namespace = "foo_ns";
        long sizeLimit = 0x100000L;
        SpaceViolationPolicy policy = SpaceViolationPolicy.NO_WRITES;
        SpaceLimitSettings settings = new SpaceLimitSettings("foo_ns", 0x100000L, policy);
        MasterProtos.SetQuotaRequest proto = QuotaSettings.buildSetQuotaRequestProto((QuotaSettings)settings);
        Assert.assertFalse((String)"User should be missing", (boolean)proto.hasUserName());
        Assert.assertFalse((String)"TableName should be missing", (boolean)proto.hasTableName());
        Assert.assertEquals((Object)"foo_ns", (Object)proto.getNamespace());
        QuotaProtos.SpaceLimitRequest spaceLimitReq = proto.getSpaceLimit();
        Assert.assertNotNull((String)"SpaceLimitRequest was null", (Object)spaceLimitReq);
        QuotaProtos.SpaceQuota spaceQuota = spaceLimitReq.getQuota();
        Assert.assertNotNull((String)"SpaceQuota was null", (Object)spaceQuota);
        Assert.assertEquals((long)0x100000L, (long)spaceQuota.getSoftLimit());
        Assert.assertEquals((Object)ProtobufUtil.toProtoViolationPolicy((SpaceViolationPolicy)policy), (Object)spaceQuota.getViolationPolicy());
        Assert.assertEquals((Object)QuotaType.SPACE, (Object)settings.getQuotaType());
        SpaceLimitSettings copy = new SpaceLimitSettings("foo_ns", 0x100000L, policy);
        Assert.assertEquals((Object)settings, (Object)copy);
        Assert.assertEquals((long)settings.hashCode(), (long)copy.hashCode());
    }

    @Test
    public void testQuotaMerging() throws IOException {
        TableName tn = TableName.valueOf((String)"foo");
        QuotaSettings originalSettings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x100000L, (SpaceViolationPolicy)SpaceViolationPolicy.DISABLE);
        QuotaSettings largerSizeLimit = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x500000L, (SpaceViolationPolicy)SpaceViolationPolicy.DISABLE);
        QuotaSettings differentPolicy = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x100000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_WRITES);
        QuotaSettings incompatibleSettings = QuotaSettingsFactory.limitNamespaceSpace((String)"ns1", (long)0x500000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_WRITES);
        Assert.assertEquals((Object)originalSettings.merge(largerSizeLimit), (Object)largerSizeLimit);
        Assert.assertEquals((Object)originalSettings.merge(differentPolicy), (Object)differentPolicy);
        try {
            originalSettings.merge(incompatibleSettings);
            Assert.fail((String)"Should not be able to merge a Table space quota with a namespace space quota.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

