/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.BuilderStyleTest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestReplicationPeerConfig {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationPeerConfig.class);
    private static final String NAMESPACE_REPLICATE = "replicate";
    private static final String NAMESPACE_OTHER = "other";
    private static final TableName TABLE_A = TableName.valueOf((String)"replicate", (String)"testA");
    private static final TableName TABLE_B = TableName.valueOf((String)"replicate", (String)"testB");
    private static final byte[] FAMILY1 = Bytes.toBytes((String)"cf1");
    private static final byte[] FAMILY2 = Bytes.toBytes((String)"cf2");

    @Test
    public void testClassMethodsAreBuilderStyle() {
        BuilderStyleTest.assertClassesAreBuilderStyle(ReplicationPeerConfig.class);
    }

    @Test
    public void testNeedToReplicateWithReplicatingAll() {
        ReplicationPeerConfig peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(true).build();
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A));
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(true).setExcludeTableCFsMap((Map)Maps.newHashMap()).build();
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A));
        HashMap tableCfs = Maps.newHashMap();
        tableCfs.put(TABLE_B, null);
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(true).setExcludeTableCFsMap((Map)tableCfs).build();
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A));
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_B));
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(true).setExcludeNamespaces((Set)Sets.newHashSet()).build();
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A));
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(true).setExcludeNamespaces((Set)Sets.newHashSet((Object[])new String[]{NAMESPACE_OTHER})).build();
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A));
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(true).setExcludeNamespaces((Set)Sets.newHashSet((Object[])new String[]{NAMESPACE_REPLICATE})).build();
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A));
        tableCfs = Maps.newHashMap();
        tableCfs.put(TABLE_A, null);
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(true).setExcludeNamespaces((Set)Sets.newHashSet((Object[])new String[]{NAMESPACE_REPLICATE})).setExcludeTableCFsMap((Map)tableCfs).build();
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A));
        tableCfs = Maps.newHashMap();
        tableCfs.put(TABLE_A, null);
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(true).setExcludeTableCFsMap((Map)tableCfs).setExcludeNamespaces((Set)Sets.newHashSet((Object[])new String[]{NAMESPACE_OTHER})).build();
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A));
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_B));
        tableCfs = Maps.newHashMap();
        tableCfs.put(TABLE_B, null);
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(true).setExcludeTableCFsMap((Map)tableCfs).setExcludeNamespaces((Set)Sets.newHashSet((Object[])new String[]{NAMESPACE_REPLICATE})).build();
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A));
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_B));
    }

    @Test
    public void testNeedToReplicateWithoutReplicatingAll() {
        ReplicationPeerConfig peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(false).build();
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A));
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(false).setTableCFsMap((Map)Maps.newHashMap()).build();
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A));
        HashMap tableCfs = Maps.newHashMap();
        tableCfs.put(TABLE_B, null);
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(false).setTableCFsMap((Map)tableCfs).build();
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A));
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_B));
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(false).setNamespaces((Set)Sets.newHashSet()).build();
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A));
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(false).setNamespaces((Set)Sets.newHashSet((Object[])new String[]{NAMESPACE_OTHER})).build();
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A));
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(false).setNamespaces((Set)Sets.newHashSet((Object[])new String[]{NAMESPACE_REPLICATE})).build();
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A));
        tableCfs = Maps.newHashMap();
        tableCfs.put(TABLE_A, null);
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(false).setTableCFsMap((Map)tableCfs).setNamespaces((Set)Sets.newHashSet((Object[])new String[]{NAMESPACE_REPLICATE})).build();
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A));
        tableCfs = Maps.newHashMap();
        tableCfs.put(TABLE_A, null);
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(false).setTableCFsMap((Map)tableCfs).setNamespaces((Set)Sets.newHashSet((Object[])new String[]{NAMESPACE_OTHER})).build();
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A));
        tableCfs = Maps.newHashMap();
        tableCfs.put(TABLE_B, null);
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(false).setNamespaces((Set)Sets.newHashSet((Object[])new String[]{NAMESPACE_REPLICATE})).setTableCFsMap((Map)tableCfs).build();
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A));
    }

    @Test
    public void testNeedToReplicateCFWithReplicatingAll() {
        HashMap excludeTableCfs = Maps.newHashMap();
        excludeTableCfs.put(TABLE_A, null);
        ReplicationPeerConfig peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(true).setExcludeTableCFsMap((Map)excludeTableCfs).build();
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A));
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A, FAMILY1));
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A, FAMILY2));
        excludeTableCfs = Maps.newHashMap();
        excludeTableCfs.put(TABLE_A, Lists.newArrayList());
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(true).setExcludeTableCFsMap((Map)excludeTableCfs).build();
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A));
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A, FAMILY1));
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A, FAMILY2));
        excludeTableCfs = Maps.newHashMap();
        excludeTableCfs.put(TABLE_A, Lists.newArrayList((Object[])new String[]{Bytes.toString((byte[])FAMILY1)}));
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(true).setExcludeTableCFsMap((Map)excludeTableCfs).build();
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A));
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A, FAMILY1));
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A, FAMILY2));
    }

    @Test
    public void testNeedToReplicateCFWithoutReplicatingAll() {
        HashMap tableCfs = Maps.newHashMap();
        tableCfs.put(TABLE_A, null);
        ReplicationPeerConfig peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(false).setTableCFsMap((Map)tableCfs).build();
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A));
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A, FAMILY1));
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A, FAMILY2));
        tableCfs = Maps.newHashMap();
        tableCfs.put(TABLE_A, Lists.newArrayList());
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(false).setTableCFsMap((Map)tableCfs).build();
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A));
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A, FAMILY1));
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A, FAMILY2));
        tableCfs = Maps.newHashMap();
        tableCfs.put(TABLE_A, Lists.newArrayList((Object[])new String[]{Bytes.toString((byte[])FAMILY1)}));
        peerConfig = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl().setReplicateAllUserTables(false).setTableCFsMap((Map)tableCfs).build();
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A));
        Assert.assertTrue((boolean)peerConfig.needToReplicate(TABLE_A, FAMILY1));
        Assert.assertFalse((boolean)peerConfig.needToReplicate(TABLE_A, FAMILY2));
    }
}

