/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.provider;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.security.provider.BuiltInProviderSelector;
import org.apache.hadoop.hbase.security.provider.BuiltInSaslAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.DigestSaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.GssSaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.SimpleSaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestDefaultProviderSelector {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDefaultProviderSelector.class);
    BuiltInProviderSelector selector;

    @Before
    public void setup() {
        this.selector = new BuiltInProviderSelector();
    }

    @Test(expected=IllegalStateException.class)
    public void testExceptionOnMissingProviders() {
        this.selector.configure(new Configuration(false), Collections.emptySet());
    }

    @Test(expected=NullPointerException.class)
    public void testNullConfiguration() {
        this.selector.configure(null, Collections.emptySet());
    }

    @Test(expected=NullPointerException.class)
    public void testNullProviderMap() {
        this.selector.configure(new Configuration(false), null);
    }

    @Test(expected=IllegalStateException.class)
    public void testDuplicateProviders() {
        HashSet<SimpleSaslClientAuthenticationProvider> providers = new HashSet<SimpleSaslClientAuthenticationProvider>();
        providers.add(new SimpleSaslClientAuthenticationProvider());
        providers.add(new SimpleSaslClientAuthenticationProvider());
        this.selector.configure(new Configuration(false), providers);
    }

    @Test
    public void testExpectedProviders() {
        HashSet<BuiltInSaslAuthenticationProvider> providers = new HashSet<BuiltInSaslAuthenticationProvider>(Arrays.asList(new SimpleSaslClientAuthenticationProvider(), new GssSaslClientAuthenticationProvider(), new DigestSaslClientAuthenticationProvider()));
        this.selector.configure(new Configuration(false), providers);
        Assert.assertNotNull((String)"Simple provider was null", (Object)this.selector.simpleAuth);
        Assert.assertNotNull((String)"Kerberos provider was null", (Object)this.selector.krbAuth);
        Assert.assertNotNull((String)"Digest provider was null", (Object)this.selector.digestAuth);
    }
}

