/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.util.StringUtils;
import org.apache.pig.impl.util.UDFContext;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DateTimeWritable
implements WritableComparable {
    private static List<String> availableZoneIDs = null;
    private DateTime value = null;

    public DateTimeWritable() {
    }

    public DateTimeWritable(DateTime dt) {
        this.value = dt;
    }

    public void readFields(DataInput in) throws IOException {
        this.retrieveAvailableZoneList();
        long instant = in.readLong();
        int offsetInMillis = in.readInt();
        int zoneListPos = in.readInt();
        DateTimeZone timeZone = null;
        timeZone = zoneListPos != -1 ? DateTimeZone.forID(availableZoneIDs.get(zoneListPos)) : DateTimeZone.forOffsetMillis(offsetInMillis);
        this.value = new DateTime(instant, timeZone);
    }

    public void write(DataOutput out) throws IOException {
        this.retrieveAvailableZoneList();
        String zoneId = this.value.getZone().getID();
        int offsetInMillis = this.value.getZone().getOffset(0L);
        int zoneListPos = availableZoneIDs.indexOf(zoneId);
        out.writeLong(this.value.getMillis());
        out.writeInt(offsetInMillis);
        out.writeInt(zoneListPos);
    }

    public void set(DateTime dt) {
        this.value = dt;
    }

    public DateTime get() {
        return this.value;
    }

    private void retrieveAvailableZoneList() throws IOException {
        if (availableZoneIDs != null) {
            return;
        }
        Properties props = UDFContext.getUDFContext().getUDFProperties("pig.datetime.zones.list".getClass());
        Collection zoneList = StringUtils.getStringCollection((String)props.getProperty("pig.datetime.zones.list"));
        if (zoneList == null || zoneList.size() == 0) {
            throw new IOException("Datetime zone information not set");
        }
        availableZoneIDs = new ArrayList<String>(zoneList);
    }

    public static void setupAvailableZoneIds() {
        TreeSet<String> sortedZoneIDs = new TreeSet<String>(DateTimeZone.getAvailableIDs());
        Properties props = UDFContext.getUDFContext().getUDFProperties("pig.datetime.zones.list".getClass());
        props.setProperty("pig.datetime.zones.list", StringUtils.arrayToString((String[])sortedZoneIDs.toArray(new String[0])));
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateTimeWritable)) {
            return false;
        }
        DateTimeWritable other = (DateTimeWritable)o;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public int compareTo(Object o) {
        DateTimeWritable other = (DateTimeWritable)o;
        return this.value.compareTo(other.value);
    }

    public String toString() {
        return this.value.toString();
    }

    static {
        WritableComparator.define(DateTimeWritable.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(DateTimeWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            DateTime thisValue = new DateTime(Comparator.readLong((byte[])b1, (int)s1));
            DateTime thatValue = new DateTime(Comparator.readLong((byte[])b2, (int)s2));
            return thisValue.compareTo(thatValue);
        }
    }
}

