/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.data.Tuple;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.runtime.AbstractFunction1;

public class LocalRearrangeConverter
implements RDDConverter<Tuple, Tuple, PhysicalOperator> {
    private static final Log LOG = LogFactory.getLog(LocalRearrangeConverter.class);

    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, PhysicalOperator physicalOperator) throws IOException {
        SparkUtil.assertPredecessorSize(predecessors, physicalOperator, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        return rdd.map((Function1)new LocalRearrangeFunction(physicalOperator), SparkUtil.getManifest(Tuple.class));
    }

    private static class LocalRearrangeFunction
    extends AbstractFunction1<Tuple, Tuple>
    implements Serializable {
        private final PhysicalOperator physicalOperator;

        public LocalRearrangeFunction(PhysicalOperator physicalOperator) {
            this.physicalOperator = physicalOperator;
        }

        public Tuple apply(Tuple t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("LocalRearrangeFunction in " + t));
            }
            try {
                this.physicalOperator.setInputs(null);
                this.physicalOperator.attachInput(t);
                Result result = this.physicalOperator.getNextTuple();
                if (result == null) {
                    throw new RuntimeException("Null response found for LocalRearange on tuple: " + t);
                }
                switch (result.returnStatus) {
                    case 0: {
                        Tuple resultTuple = (Tuple)result.result;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("LocalRearrangeFunction out " + resultTuple));
                        }
                        return resultTuple;
                    }
                }
                throw new RuntimeException("Unexpected response code from operator " + this.physicalOperator + " : " + result);
            }
            catch (ExecException e) {
                throw new RuntimeException("Couldn't do LocalRearange on tuple: " + t, e);
            }
        }
    }
}

