/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.optimizer;

import org.apache.hadoop.mapred.JobConf;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.NativeSparkOperator;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class ParallelismSetter
extends SparkOpPlanVisitor {
    private JobConf jobConf;

    public ParallelismSetter(SparkOperPlan plan, JobConf jobConf) {
        super(plan, (PlanWalker<SparkOperator, SparkOperPlan>)new DependencyOrderWalker<SparkOperator, SparkOperPlan>(plan));
        this.jobConf = jobConf;
    }

    @Override
    public void visitSparkOp(SparkOperator sparkOp) throws VisitorException {
        if (sparkOp instanceof NativeSparkOperator) {
            return;
        }
        if (sparkOp.getCrossKeys() != null) {
            for (String key : sparkOp.getCrossKeys()) {
                this.jobConf.set("pig.cross.parallelism." + key, Integer.toString(96));
            }
        }
    }
}

