/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class NoopFilterRemover
extends TezOpPlanVisitor {
    private static Log LOG = LogFactory.getLog(NoopFilterRemover.class);

    public NoopFilterRemover(TezOperPlan plan) {
        super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(plan));
    }

    @Override
    public void visitTezOp(TezOperator tezOp) throws VisitorException {
        if (tezOp.getSplitParent() == null) {
            return;
        }
        try {
            LinkedList<POFilter> filters = PlanHelper.getPhysicalOperators(tezOp.plan, POFilter.class);
            for (POFilter filter : filters) {
                Boolean filterValue;
                ConstantExpression exp;
                Object value;
                PhysicalOperator fp;
                PhysicalPlan filterPlan = filter.getPlan();
                if (filterPlan.size() != 1 || !((fp = (PhysicalOperator)filterPlan.getRoots().get(0)) instanceof ConstantExpression) || !((value = (exp = (ConstantExpression)fp).getValue()) instanceof Boolean) || !(filterValue = (Boolean)value).booleanValue()) continue;
                tezOp.plan.removeAndReconnect(filter);
            }
        }
        catch (PlanException e) {
            throw new VisitorException(e);
        }
    }
}

