/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class REGEX_EXTRACT
extends EvalFunc<String> {
    String mExpression = null;
    Pattern mPattern = null;
    boolean mUseMatches = false;

    public REGEX_EXTRACT() {
    }

    public REGEX_EXTRACT(String useMatches) {
        this.mUseMatches = Boolean.parseBoolean(useMatches);
    }

    @Override
    public Schema outputSchema(Schema input) {
        try {
            return new Schema(new Schema.FieldSchema(this.getSchemaName(this.getClass().getName().toLowerCase(), input), 55));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String exec(Tuple input) throws IOException {
        block7: {
            if (input.size() != 3) {
                String msg = "RegexExtract : Only 3 parameters are allowed.";
                throw new IOException(msg);
            }
            if (input.get(0) == null) {
                return null;
            }
            try {
                if (input.get(1).equals(this.mExpression)) break block7;
                try {
                    this.mExpression = (String)input.get(1);
                    this.mPattern = Pattern.compile(this.mExpression);
                }
                catch (Exception e) {
                    String msg = "RegexExtract : Mal-Formed Regular expression : " + input.get(1);
                    throw new IOException(msg);
                }
            }
            catch (NullPointerException e) {
                String msg = "RegexExtract : Regular expression is null";
                throw new IOException(msg);
            }
        }
        int mIndex = (Integer)input.get(2);
        Matcher m = this.mPattern.matcher((String)input.get(0));
        if ((!this.mUseMatches && m.find() || this.mUseMatches && m.matches()) && m.groupCount() >= mIndex) {
            return m.group(mIndex);
        }
        return null;
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 10));
        funcList.add(new FuncSpec(this.getClass().getName(), s));
        return funcList;
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

