/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataReaderWriter;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;

public class LimitedSortedDataBag
implements DataBag {
    private static final Log log = LogFactory.getLog(LimitedSortedDataBag.class);
    private static final long serialVersionUID = 1L;
    private final Comparator<Tuple> mComp;
    private final PriorityQueue<Tuple> priorityQ;
    private final long limit;

    public LimitedSortedDataBag(Comparator<Tuple> comp, long limit) {
        this.mComp = comp == null ? new DefaultComparator() : comp;
        this.limit = limit;
        this.priorityQ = new PriorityQueue<Tuple>((int)limit, this.getReversedComparator(this.mComp));
    }

    @Override
    public long size() {
        return this.priorityQ.size();
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public boolean isDistinct() {
        return false;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new LimitedSortedDataBagIterator();
    }

    @Override
    public void add(Tuple t) {
        this.priorityQ.add(t);
        if ((long)this.priorityQ.size() > this.limit) {
            this.priorityQ.poll();
        }
    }

    @Override
    public void addAll(DataBag b) {
        Iterator<Tuple> it = b.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    @Override
    public void clear() {
        this.priorityQ.clear();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.size());
        for (Tuple item : this) {
            item.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        long size = in.readLong();
        for (long i = 0L; i < size; ++i) {
            Object o = DataReaderWriter.readDatum(in);
            this.add((Tuple)o);
            continue;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        Iterator<Tuple> it = this.iterator();
        while (it.hasNext()) {
            Tuple t = it.next();
            String s = t.toString();
            sb.append(s);
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append('}');
        return sb.toString();
    }

    public int compareTo(Object other) {
        if (this == other) {
            return 0;
        }
        if (other instanceof DataBag) {
            DataBag bOther = (DataBag)other;
            if (this.size() != bOther.size()) {
                if (this.size() > bOther.size()) {
                    return 1;
                }
                return -1;
            }
            LimitedSortedDataBag otherCloneDataBag = new LimitedSortedDataBag(this.mComp, this.limit);
            otherCloneDataBag.addAll((DataBag)other);
            Iterator<Tuple> thisIt = this.iterator();
            Iterator<Tuple> otherIt = otherCloneDataBag.iterator();
            while (thisIt.hasNext() && otherIt.hasNext()) {
                Tuple otherT;
                Tuple thisT = thisIt.next();
                int c = thisT.compareTo(otherT = otherIt.next());
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return DataType.compare(this, other);
    }

    @Override
    public void markStale(boolean stale) {
        throw new RuntimeException("LimitedSortedDataBag cannot be marked stale");
    }

    @Override
    public long spill() {
        return 0L;
    }

    @Override
    public long getMemorySize() {
        return 0L;
    }

    private <T> Comparator<T> getReversedComparator(final Comparator<T> comp) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return -comp.compare(o1, o2);
            }

            @Override
            public boolean equals(Object o) {
                return comp.equals(o);
            }
        };
    }

    protected void reportProgress() {
        if (PhysicalOperator.getReporter() != null) {
            PhysicalOperator.getReporter().progress();
        }
    }

    private class LimitedSortedDataBagIterator
    implements Iterator<Tuple> {
        private int mCntr = 0;
        private final List<Tuple> mContents;

        public LimitedSortedDataBagIterator() {
            this.mContents = new ArrayList<Tuple>(LimitedSortedDataBag.this.priorityQ);
            Collections.sort(this.mContents, LimitedSortedDataBag.this.mComp);
        }

        @Override
        public boolean hasNext() {
            return this.mCntr < this.mContents.size();
        }

        @Override
        public Tuple next() {
            if ((this.mCntr & 0x3FF) == 0) {
                LimitedSortedDataBag.this.reportProgress();
            }
            return this.mContents.get(this.mCntr++);
        }

        @Override
        public void remove() {
            throw new RuntimeException("Cannot remove() from LimitedSortedDataBag.iterator()");
        }
    }

    private static class DefaultComparator
    implements Comparator<Tuple> {
        private DefaultComparator() {
        }

        @Override
        public int compare(Tuple t1, Tuple t2) {
            return t1.compareTo(t2);
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }

        public int hashCode() {
            return 42;
        }
    }
}

