/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan;

import java.util.List;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Pair;

public class ProjectionMap {
    private boolean mChanges = true;
    private MultiMap<Integer, Column> mMappedFields;
    private List<Pair<Integer, Integer>> mRemovedFields;
    private List<Integer> mAddedFields;

    public ProjectionMap(boolean changes) {
        this(null, null, null, changes);
    }

    public ProjectionMap(MultiMap<Integer, Column> mapFields, List<Pair<Integer, Integer>> removedFields, List<Integer> addedFields) {
        this(mapFields, removedFields, addedFields, true);
    }

    private ProjectionMap(MultiMap<Integer, Column> mapFields, List<Pair<Integer, Integer>> removedFields, List<Integer> addedFields, boolean changes) {
        this.mMappedFields = mapFields;
        this.mAddedFields = addedFields;
        this.mRemovedFields = removedFields;
        this.mChanges = changes;
    }

    public MultiMap<Integer, Column> getMappedFields() {
        return this.mMappedFields;
    }

    public void setMappedFields(MultiMap<Integer, Column> fields) {
        this.mMappedFields = fields;
    }

    public List<Pair<Integer, Integer>> getRemovedFields() {
        return this.mRemovedFields;
    }

    public void setRemovedFields(List<Pair<Integer, Integer>> fields) {
        this.mRemovedFields = fields;
    }

    public List<Integer> getAddedFields() {
        return this.mAddedFields;
    }

    public void setAddedFields(List<Integer> fields) {
        this.mAddedFields = fields;
    }

    public boolean changes() {
        return this.getChanges();
    }

    public boolean getChanges() {
        return this.mChanges;
    }

    public void setChanges(boolean changes) {
        this.mChanges = changes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("changes: " + this.mChanges);
        sb.append(" mapped fields: " + this.mMappedFields);
        sb.append(" added fields: " + this.mAddedFields);
        sb.append(" removed fields: " + this.mRemovedFields);
        return sb.toString();
    }

    public static class Column {
        private Pair<Integer, Integer> mInputColumn;
        private boolean mCast = false;
        private byte mCastType = 0;

        public Column(Pair<Integer, Integer> inputColumn) {
            this(inputColumn, false, 0);
        }

        public Column(Pair<Integer, Integer> inputColumn, boolean cast, byte castType) {
            this.mInputColumn = inputColumn;
            this.mCast = cast;
            this.mCastType = castType;
        }

        public Pair<Integer, Integer> getInputColumn() {
            return this.mInputColumn;
        }

        public boolean getCast() {
            return this.mCast;
        }

        public boolean cast() {
            return this.getCast();
        }

        public byte getCastType() {
            return this.mCastType;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.mInputColumn);
            if (this.mCast) {
                sb.append(" cast to: " + DataType.findTypeName(this.mCastType));
            }
            return sb.toString();
        }
    }
}

