/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.spark;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.LongAccumulator;

public abstract class SparkCounter<T>
implements Serializable {
    private String name;
    private String displayName;
    private AccumulatorV2<T, T> accumulator;

    public SparkCounter() {
    }

    public SparkCounter(String name, String displayName, String groupName, T initValue, JavaSparkContext sparkContext) {
        this.name = name;
        this.displayName = displayName;
        String accumulatorName = groupName + "_" + name;
        if (sparkContext == null) {
            throw new RuntimeException("Not allowed to create SparkCounter on backend executor.");
        }
        this.accumulator = this.getAccumulator();
        sparkContext.sc().register(this.accumulator, accumulatorName);
    }

    public T getValue() {
        if (this.accumulator != null) {
            return (T)this.accumulator.value();
        }
        return null;
    }

    public void increment(T incr) {
        this.accumulator.add(incr);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public abstract AccumulatorV2<T, T> getAccumulator();

    public static class MapSparkCounter
    extends SparkCounter<Map<String, Long>> {
        public MapSparkCounter() {
        }

        public MapSparkCounter(String name, String displayName, String groupName, Map<String, Long> initValue, JavaSparkContext sparkContext) {
            super(name, displayName, groupName, initValue, sparkContext);
        }

        @Override
        public AccumulatorV2<Map<String, Long>, Map<String, Long>> getAccumulator() {
            return new MapAccumulator();
        }

        private class MapAccumulator
        extends AccumulatorV2<Map<String, Long>, Map<String, Long>> {
            private Map<String, Long> map;

            public MapAccumulator() {
                this(new HashMap<String, Long>());
            }

            public MapAccumulator(Map<String, Long> in) {
                this.map = in;
            }

            public AccumulatorV2<Map<String, Long>, Map<String, Long>> copy() {
                return new MapAccumulator((Map<String, Long>)this.value());
            }

            public void add(Map<String, Long> r2) {
                for (String key : r2.keySet()) {
                    Long r1val = this.map.get(key);
                    Long r2val = r2.get(key);
                    this.map.put(key, r1val == null ? r2val : r1val + r2val);
                }
            }

            public boolean isZero() {
                return this.map == null || this.map.isEmpty();
            }

            public void merge(AccumulatorV2<Map<String, Long>, Map<String, Long>> other) {
                this.add((Map)other.value());
            }

            public void reset() {
                if (this.map != null) {
                    this.map.clear();
                } else {
                    this.map = new HashMap<String, Long>();
                }
            }

            public Map<String, Long> value() {
                return this.map;
            }
        }
    }

    public static class LongSparkCounter
    extends SparkCounter<Long> {
        public LongSparkCounter() {
        }

        public LongSparkCounter(String name, String displayName, String groupName, Long initValue, JavaSparkContext sparkContext) {
            super(name, displayName, groupName, initValue, sparkContext);
        }

        @Override
        public AccumulatorV2<Long, Long> getAccumulator() {
            return new LongAccumulator();
        }
    }
}

