/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics.sink;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.spark.SparkConf;
import org.apache.spark.metrics.sink.Sink;
import org.apache.spark.ui.JettyUtils;
import org.apache.spark.ui.JettyUtils$;
import org.apache.spark.ui.JettyUtils$ServletParams$;
import org.sparkproject.jetty.servlet.ServletContextHandler;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005-a!\u0002\t\u0012\u0001UY\u0002\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011\u0001\u0015\t\u0011E\u0002!\u0011!Q\u0001\n%B\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\t{\u0001\u0011\t\u0011)A\u0005i!)a\b\u0001C\u0001\u007f!91\t\u0001b\u0001\n\u0003!\u0005BB&\u0001A\u0003%Q\tC\u0004M\u0001\t\u0007I\u0011\u0001#\t\r5\u0003\u0001\u0015!\u0003F\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015Q\b\u0001\"\u0003|\u0011\u0015q\b\u0001\"\u0011\u0000\u0011\u0019\t9\u0001\u0001C!\u007f\"1\u0011\u0011\u0002\u0001\u0005B}\u0014\u0011\u0003\u0015:p[\u0016$\b.Z;t'\u0016\u0014h\u000f\\3u\u0015\t\u00112#\u0001\u0003tS:\\'B\u0001\u000b\u0016\u0003\u001diW\r\u001e:jGNT!AF\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\n\u0004\u0001q\u0011\u0003CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g\r\u0005\u0002$I5\t\u0011#\u0003\u0002&#\t!1+\u001b8l\u0003!\u0001(o\u001c9feRL8\u0001A\u000b\u0002SA\u0011!fL\u0007\u0002W)\u0011A&L\u0001\u0005kRLGNC\u0001/\u0003\u0011Q\u0017M^1\n\u0005AZ#A\u0003)s_B,'\u000f^5fg\u0006I\u0001O]8qKJ$\u0018\u0010I\u0001\te\u0016<\u0017n\u001d;ssV\tA\u0007\u0005\u00026w5\taG\u0003\u0002\u0015o)\u0011\u0001(O\u0001\tG>$\u0017\r[1mK*\t!(A\u0002d_6L!\u0001\u0010\u001c\u0003\u001d5+GO]5d%\u0016<\u0017n\u001d;ss\u0006I!/Z4jgR\u0014\u0018\u0010I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0001\u000b%\t\u0005\u0002$\u0001!)a%\u0002a\u0001S!)!'\u0002a\u0001i\u0005\u00012+\u0012*W\u0019\u0016#vlS#Z?B\u000bE\u000bS\u000b\u0002\u000bB\u0011a)S\u0007\u0002\u000f*\u0011\u0001*L\u0001\u0005Y\u0006tw-\u0003\u0002K\u000f\n11\u000b\u001e:j]\u001e\f\u0011cU#S-2+EkX&F3~\u0003\u0016\t\u0016%!\u0003-\u0019XM\u001d<mKR\u0004\u0016\r\u001e5\u0002\u0019M,'O\u001e7fiB\u000bG\u000f\u001b\u0011\u0002\u0017\u001d,G\u000fS1oI2,'o\u001d\u000b\u0003!v\u00032!H)T\u0013\t\u0011fDA\u0003BeJ\f\u0017\u0010\u0005\u0002U76\tQK\u0003\u0002W/\u000691/\u001a:wY\u0016$(B\u0001-Z\u0003\u0015QW\r\u001e;z\u0015\tQ\u0016$A\u0004fG2L\u0007o]3\n\u0005q+&!F*feZdW\r^\"p]R,\u0007\u0010\u001e%b]\u0012dWM\u001d\u0005\u0006=*\u0001\raX\u0001\u0005G>tg\r\u0005\u0002aC6\tQ#\u0003\u0002c+\tI1\u000b]1sW\u000e{gNZ\u0001\u0013O\u0016$X*\u001a;sS\u000e\u001c8K\\1qg\"|G\u000f\u0006\u0002f_B\u0011a-\u001c\b\u0003O.\u0004\"\u0001\u001b\u0010\u000e\u0003%T!A[\u0014\u0002\rq\u0012xn\u001c;?\u0013\tag$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015:T!\u0001\u001c\u0010\t\u000bA\\\u0001\u0019A9\u0002\u000fI,\u0017/^3tiB\u0011!\u000f_\u0007\u0002g*\u0011A/^\u0001\u0005QR$\bO\u0003\u0002Wm*\tq/A\u0003kCZ\f\u00070\u0003\u0002zg\n\u0011\u0002\n\u001e;q'\u0016\u0014h\u000f\\3u%\u0016\fX/Z:u\u00031qwN]7bY&TXmS3z)\t)G\u0010C\u0003~\u0019\u0001\u0007Q-A\u0002lKf\fQa\u001d;beR$\"!!\u0001\u0011\u0007u\t\u0019!C\u0002\u0002\u0006y\u0011A!\u00168ji\u0006!1\u000f^8q\u0003\u0019\u0011X\r]8si\u0002")
public class PrometheusServlet
implements Sink {
    private final Properties property;
    private final MetricRegistry registry;
    private final String SERVLET_KEY_PATH;
    private final String servletPath;

    public Properties property() {
        return this.property;
    }

    public MetricRegistry registry() {
        return this.registry;
    }

    public String SERVLET_KEY_PATH() {
        return this.SERVLET_KEY_PATH;
    }

    public String servletPath() {
        return this.servletPath;
    }

    public ServletContextHandler[] getHandlers(SparkConf conf) {
        return (ServletContextHandler[])((Object[])new ServletContextHandler[]{JettyUtils$.MODULE$.createServletHandler(this.servletPath(), new JettyUtils.ServletParams<Object>((Function1 & Serializable & scala.Serializable)request -> this.getMetricsSnapshot((HttpServletRequest)request), "text/plain", JettyUtils$ServletParams$.MODULE$.$lessinit$greater$default$3()), conf, JettyUtils$.MODULE$.createServletHandler$default$4())});
    }

    public String getMetricsSnapshot(HttpServletRequest request) {
        String countersLabel;
        String gaugesLabel = "{type=\"gauges\"}";
        String metersLabel = countersLabel = "{type=\"counters\"}";
        String histogramslabels = "{type=\"histograms\"}";
        String timersLabels = "{type=\"timers\"}";
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.registry().getGauges()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Gauge v = (Gauge)tuple2._2();
                if (!(v.getValue() instanceof String)) {
                    sb.append(new StringBuilder(8).append(this.normalizeKey(k)).append("Number").append(gaugesLabel).append(" ").append(v.getValue()).append("\n").toString());
                    return sb.append(new StringBuilder(7).append(this.normalizeKey(k)).append("Value").append(gaugesLabel).append(" ").append(v.getValue()).append("\n").toString());
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.registry().getCounters()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Counter v = (Counter)tuple2._2();
                return sb.append(new StringBuilder(7).append(this.normalizeKey(k)).append("Count").append(countersLabel).append(" ").append(v.getCount()).append("\n").toString());
            }
            throw new MatchError((Object)tuple2);
        });
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.registry().getHistograms()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Histogram h = (Histogram)tuple2._2();
                Snapshot snapshot = h.getSnapshot();
                String prefix = this.normalizeKey(k);
                sb.append(new StringBuilder(7).append(prefix).append("Count").append(histogramslabels).append(" ").append(h.getCount()).append("\n").toString());
                sb.append(new StringBuilder(5).append(prefix).append("Max").append(histogramslabels).append(" ").append(snapshot.getMax()).append("\n").toString());
                sb.append(new StringBuilder(6).append(prefix).append("Mean").append(histogramslabels).append(" ").append(snapshot.getMean()).append("\n").toString());
                sb.append(new StringBuilder(5).append(prefix).append("Min").append(histogramslabels).append(" ").append(snapshot.getMin()).append("\n").toString());
                sb.append(new StringBuilder(16).append(prefix).append("50thPercentile").append(histogramslabels).append(" ").append(snapshot.getMedian()).append("\n").toString());
                sb.append(new StringBuilder(16).append(prefix).append("75thPercentile").append(histogramslabels).append(" ").append(snapshot.get75thPercentile()).append("\n").toString());
                sb.append(new StringBuilder(16).append(prefix).append("95thPercentile").append(histogramslabels).append(" ").append(snapshot.get95thPercentile()).append("\n").toString());
                sb.append(new StringBuilder(16).append(prefix).append("98thPercentile").append(histogramslabels).append(" ").append(snapshot.get98thPercentile()).append("\n").toString());
                sb.append(new StringBuilder(16).append(prefix).append("99thPercentile").append(histogramslabels).append(" ").append(snapshot.get99thPercentile()).append("\n").toString());
                sb.append(new StringBuilder(17).append(prefix).append("999thPercentile").append(histogramslabels).append(" ").append(snapshot.get999thPercentile()).append("\n").toString());
                return sb.append(new StringBuilder(8).append(prefix).append("StdDev").append(histogramslabels).append(" ").append(snapshot.getStdDev()).append("\n").toString());
            }
            throw new MatchError((Object)tuple2);
        });
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.registry().getMeters().entrySet().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)kv -> {
            String prefix = this.normalizeKey((String)kv.getKey());
            Meter meter = (Meter)kv.getValue();
            sb.append(new StringBuilder(7).append(prefix).append("Count").append(metersLabel).append(" ").append(meter.getCount()).append("\n").toString());
            sb.append(new StringBuilder(10).append(prefix).append("MeanRate").append(metersLabel).append(" ").append(meter.getMeanRate()).append("\n").toString());
            sb.append(new StringBuilder(15).append(prefix).append("OneMinuteRate").append(metersLabel).append(" ").append(meter.getOneMinuteRate()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("FiveMinuteRate").append(metersLabel).append(" ").append(meter.getFiveMinuteRate()).append("\n").toString());
            return sb.append(new StringBuilder(19).append(prefix).append("FifteenMinuteRate").append(metersLabel).append(" ").append(meter.getFifteenMinuteRate()).append("\n").toString());
        });
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.registry().getTimers().entrySet().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)kv -> {
            String prefix = this.normalizeKey((String)kv.getKey());
            Timer timer = (Timer)kv.getValue();
            Snapshot snapshot = timer.getSnapshot();
            sb.append(new StringBuilder(7).append(prefix).append("Count").append(timersLabels).append(" ").append(timer.getCount()).append("\n").toString());
            sb.append(new StringBuilder(5).append(prefix).append("Max").append(timersLabels).append(" ").append(snapshot.getMax()).append("\n").toString());
            sb.append(new StringBuilder(6).append(prefix).append("Mean").append(timersLabels).append(" ").append(snapshot.getMean()).append("\n").toString());
            sb.append(new StringBuilder(5).append(prefix).append("Min").append(timersLabels).append(" ").append(snapshot.getMin()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("50thPercentile").append(timersLabels).append(" ").append(snapshot.getMedian()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("75thPercentile").append(timersLabels).append(" ").append(snapshot.get75thPercentile()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("95thPercentile").append(timersLabels).append(" ").append(snapshot.get95thPercentile()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("98thPercentile").append(timersLabels).append(" ").append(snapshot.get98thPercentile()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("99thPercentile").append(timersLabels).append(" ").append(snapshot.get99thPercentile()).append("\n").toString());
            sb.append(new StringBuilder(17).append(prefix).append("999thPercentile").append(timersLabels).append(" ").append(snapshot.get999thPercentile()).append("\n").toString());
            sb.append(new StringBuilder(8).append(prefix).append("StdDev").append(timersLabels).append(" ").append(snapshot.getStdDev()).append("\n").toString());
            sb.append(new StringBuilder(19).append(prefix).append("FifteenMinuteRate").append(timersLabels).append(" ").append(timer.getFifteenMinuteRate()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("FiveMinuteRate").append(timersLabels).append(" ").append(timer.getFiveMinuteRate()).append("\n").toString());
            sb.append(new StringBuilder(15).append(prefix).append("OneMinuteRate").append(timersLabels).append(" ").append(timer.getOneMinuteRate()).append("\n").toString());
            return sb.append(new StringBuilder(10).append(prefix).append("MeanRate").append(timersLabels).append(" ").append(timer.getMeanRate()).append("\n").toString());
        });
        return sb.toString();
    }

    private String normalizeKey(String key) {
        return new StringBuilder(9).append("metrics_").append(key.replaceAll("[^a-zA-Z0-9]", "_")).append("_").toString();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void report() {
    }

    public PrometheusServlet(Properties property, MetricRegistry registry) {
        this.property = property;
        this.registry = registry;
        this.SERVLET_KEY_PATH = "path";
        this.servletPath = property.getProperty(this.SERVLET_KEY_PATH());
    }
}

