/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status;

import java.util.Date;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetrics;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class AppStatusUtils$ {
    public static AppStatusUtils$ MODULE$;
    private final Set<String> TASK_FINISHED_STATES;

    static {
        new AppStatusUtils$();
    }

    private Set<String> TASK_FINISHED_STATES() {
        return this.TASK_FINISHED_STATES;
    }

    private boolean isTaskFinished(TaskData task) {
        return this.TASK_FINISHED_STATES().contains((Object)task.status());
    }

    public long schedulerDelay(TaskData task) {
        if (this.isTaskFinished(task) && task.taskMetrics().isDefined() && task.duration().isDefined()) {
            TaskMetrics m = (TaskMetrics)task.taskMetrics().get();
            return this.schedulerDelay(task.launchTime().getTime(), this.fetchStart(task), BoxesRunTime.unboxToLong((Object)task.duration().get()), m.executorDeserializeTime(), m.resultSerializationTime(), m.executorRunTime());
        }
        return 0L;
    }

    public long gettingResultTime(TaskData task) {
        return this.gettingResultTime(task.launchTime().getTime(), this.fetchStart(task), BoxesRunTime.unboxToLong((Object)task.duration().getOrElse((Function0)(JFunction0.mcJ.sp & java.io.Serializable & Serializable)() -> -1L)));
    }

    public long schedulerDelay(long launchTime, long fetchStart, long duration, long deserializeTime, long serializeTime, long runTime) {
        return package$.MODULE$.max(0L, duration - runTime - deserializeTime - serializeTime - this.gettingResultTime(launchTime, fetchStart, duration));
    }

    public long gettingResultTime(long launchTime, long fetchStart, long duration) {
        if (fetchStart > 0L) {
            if (duration > 0L) {
                return launchTime + duration - fetchStart;
            }
            return System.currentTimeMillis() - fetchStart;
        }
        return 0L;
    }

    private long fetchStart(TaskData task) {
        if (task.resultFetchStart().isDefined()) {
            return ((Date)task.resultFetchStart().get()).getTime();
        }
        return -1L;
    }

    private AppStatusUtils$() {
        MODULE$ = this;
        this.TASK_FINISHED_STATES = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FAILED", "KILLED", "SUCCESS"}));
    }
}

