/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;

public class CfCqSliceOpts {
    public static final String OPT_MIN_CF = "minCf";
    public static final String OPT_MIN_CF_DESC = "UTF-8 encoded string representing minimum column family. Optional parameter. If minCf and minCq are undefined, the column slice will start at the first column of each row. If you want to do an exact match on column families, it's more efficient to leave minCf and maxCf undefined and use the scanner's fetchColumnFamily method.";
    public static final String OPT_MIN_CQ = "minCq";
    public static final String OPT_MIN_CQ_DESC = "UTF-8 encoded string representing minimum column qualifier. Optional parameter. If minCf and minCq are undefined, the column slice will start at the first column of each row.";
    public static final String OPT_MAX_CF = "maxCf";
    public static final String OPT_MAX_CF_DESC = "UTF-8 encoded string representing maximum column family. Optional parameter. If minCf and minCq are undefined, the column slice will start at the first column of each row. If you want to do an exact match on column families, it's more efficient to leave minCf and maxCf undefined and use the scanner's fetchColumnFamily method.";
    public static final String OPT_MAX_CQ = "maxCq";
    public static final String OPT_MAX_CQ_DESC = "UTF-8 encoded string representing maximum column qualifier. Optional parameter. If maxCf and MaxCq are undefined, the column slice will end at the last column of each row.";
    public static final String OPT_MIN_INCLUSIVE = "minInclusive";
    public static final String OPT_MIN_INCLUSIVE_DESC = "UTF-8 encoded string indicating whether to include the minimum column in the slice range. Optional parameter, default is true.";
    public static final String OPT_MAX_INCLUSIVE = "maxInclusive";
    public static final String OPT_MAX_INCLUSIVE_DESC = "UTF-8 encoded string indicating whether to include the maximum column in the slice range. Optional parameter, default is true.";
    Text minCf;
    Text minCq;
    Text maxCf;
    Text maxCq;
    boolean minInclusive;
    boolean maxInclusive;

    public CfCqSliceOpts(CfCqSliceOpts o) {
        this.minCf = new Text(o.minCf);
        this.minCq = new Text(o.minCq);
        this.maxCf = new Text(o.maxCf);
        this.maxCq = new Text(o.maxCq);
        this.minInclusive = o.minInclusive;
        this.maxInclusive = o.maxInclusive;
    }

    public CfCqSliceOpts(Map<String, String> options) {
        String optStr = options.get(OPT_MIN_CF);
        this.minCf = optStr == null ? new Text() : new Text(optStr.getBytes(StandardCharsets.UTF_8));
        optStr = options.get(OPT_MIN_CQ);
        this.minCq = optStr == null ? new Text() : new Text(optStr.getBytes(StandardCharsets.UTF_8));
        optStr = options.get(OPT_MAX_CF);
        this.maxCf = optStr == null ? new Text() : new Text(optStr.getBytes(StandardCharsets.UTF_8));
        optStr = options.get(OPT_MAX_CQ);
        this.maxCq = optStr == null ? new Text() : new Text(optStr.getBytes(StandardCharsets.UTF_8));
        optStr = options.get(OPT_MIN_INCLUSIVE);
        this.minInclusive = optStr == null || optStr.isEmpty() ? true : Boolean.valueOf(options.get(OPT_MIN_INCLUSIVE));
        optStr = options.get(OPT_MAX_INCLUSIVE);
        this.maxInclusive = optStr == null || optStr.isEmpty() ? true : Boolean.valueOf(options.get(OPT_MAX_INCLUSIVE));
    }

    static class Describer
    implements OptionDescriber {
        Describer() {
        }

        @Override
        public OptionDescriber.IteratorOptions describeOptions() {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put(CfCqSliceOpts.OPT_MIN_CF, CfCqSliceOpts.OPT_MIN_CF_DESC);
            options.put(CfCqSliceOpts.OPT_MIN_CQ, CfCqSliceOpts.OPT_MIN_CQ_DESC);
            options.put(CfCqSliceOpts.OPT_MAX_CF, CfCqSliceOpts.OPT_MAX_CF_DESC);
            options.put(CfCqSliceOpts.OPT_MAX_CQ, CfCqSliceOpts.OPT_MAX_CQ_DESC);
            options.put(CfCqSliceOpts.OPT_MIN_INCLUSIVE, CfCqSliceOpts.OPT_MIN_INCLUSIVE_DESC);
            options.put(CfCqSliceOpts.OPT_MAX_INCLUSIVE, CfCqSliceOpts.OPT_MAX_INCLUSIVE_DESC);
            return new OptionDescriber.IteratorOptions("ColumnSliceFilter", "Returns all key/value pairs where the column is between the specified values", options, Collections.emptyList());
        }

        @Override
        public boolean validateOptions(Map<String, String> options) {
            boolean upperBoundsExist;
            CfCqSliceOpts o = new CfCqSliceOpts(options);
            boolean boundsOk = true;
            boolean bl = upperBoundsExist = o.maxCf.getLength() > 0 && o.maxCq.getLength() > 0;
            if (upperBoundsExist) {
                boundsOk = o.maxInclusive;
            }
            boolean cqRangeOk = o.maxCq.getLength() == 0 || o.minCq.compareTo((BinaryComparable)o.maxCq) < 1;
            boolean cfRangeOk = o.maxCf.getLength() == 0 || o.minCf.compareTo((BinaryComparable)o.maxCf) < 1;
            return boundsOk && cqRangeOk && cfRangeOk;
        }
    }
}

