/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class GrepIterator
extends Filter {
    private byte[] term;
    private int[] right = new int[256];

    @Override
    public boolean accept(Key k, Value v) {
        return this.match(v.get()) || this.match(k.getRowData()) || this.match(k.getColumnFamilyData()) || this.match(k.getColumnQualifierData());
    }

    protected boolean match(ByteSequence bs) {
        return this.indexOf(bs.getBackingArray(), bs.offset(), bs.length()) >= 0;
    }

    protected boolean match(byte[] ba) {
        return this.indexOf(ba, 0, ba.length) >= 0;
    }

    protected int indexOf(byte[] value, int offset, int length) {
        int skip;
        int M = this.term.length;
        int N = offset + length;
        for (int i = offset; i <= N - M; i += skip) {
            skip = 0;
            for (int j = M - 1; j >= 0; --j) {
                if (this.term[j] == value[i + j]) continue;
                skip = Math.max(1, j - this.right[value[i + j] & 0xFF]);
            }
            if (skip != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        GrepIterator copy = (GrepIterator)super.deepCopy(env);
        copy.term = Arrays.copyOf(this.term, this.term.length);
        return copy;
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        int i;
        super.init(source, options, env);
        this.term = options.get("term").getBytes(StandardCharsets.UTF_8);
        for (i = 0; i < this.right.length; ++i) {
            this.right[i] = -1;
        }
        for (i = 0; i < this.term.length; ++i) {
            this.right[this.term[i] & 0xFF] = i;
        }
    }

    public static void setTerm(IteratorSetting cfg, String term) {
        cfg.addOption("term", term);
    }
}

