/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc;

import java.util.Arrays;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.apache.accumulo.core.client.impl.DelegationTokenImpl;
import org.apache.accumulo.core.rpc.SaslDigestCallbackHandler;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslClientDigestCallbackHandler
extends SaslDigestCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(SaslClientDigestCallbackHandler.class);
    private static final String NAME = SaslClientDigestCallbackHandler.class.getSimpleName();
    private final String userName;
    private final char[] userPassword;

    public SaslClientDigestCallbackHandler(DelegationTokenImpl token) {
        Objects.requireNonNull(token);
        this.userName = this.encodeIdentifier(token.getIdentifier().getBytes());
        this.userPassword = this.encodePassword(token.getPassword());
    }

    public SaslClientDigestCallbackHandler(String userName, char[] userPassword) {
        Objects.requireNonNull(userName);
        Objects.requireNonNull(userPassword);
        this.userName = userName;
        this.userPassword = userPassword;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        NameCallback nc = null;
        PasswordCallback pc = null;
        TextInputCallback rc = null;
        for (Callback callback : callbacks) {
            if (callback instanceof RealmChoiceCallback) continue;
            if (callback instanceof NameCallback) {
                nc = (NameCallback)callback;
                continue;
            }
            if (callback instanceof PasswordCallback) {
                pc = (PasswordCallback)callback;
                continue;
            }
            if (callback instanceof RealmCallback) {
                rc = (RealmCallback)callback;
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized SASL client callback");
        }
        if (nc != null) {
            log.debug("SASL client callback: setting username: {}", (Object)this.userName);
            nc.setName(this.userName);
        }
        if (pc != null) {
            log.debug("SASL client callback: setting userPassword");
            pc.setPassword(this.userPassword);
        }
        if (rc != null) {
            log.debug("SASL client callback: setting realm: {}", (Object)rc.getDefaultText());
            rc.setText(rc.getDefaultText());
        }
    }

    public String toString() {
        return NAME;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder(41, 47);
        hcb.append((Object)this.userName).append(this.userPassword);
        return hcb.toHashCode();
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o instanceof SaslClientDigestCallbackHandler) {
            SaslClientDigestCallbackHandler other = (SaslClientDigestCallbackHandler)o;
            return this.userName.equals(other.userName) && Arrays.equals(this.userPassword, other.userPassword);
        }
        return false;
    }
}

