/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.RSGroupProtos;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class RSGroupTableAccessor {
    private static final TableName RSGROUP_TABLE_NAME = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"rsgroup");
    private static final byte[] META_FAMILY_BYTES = Bytes.toBytes((String)"m");
    private static final byte[] META_QUALIFIER_BYTES = Bytes.toBytes((String)"i");

    private RSGroupTableAccessor() {
    }

    public static boolean isRSGroupsEnabled(Connection connection) throws IOException {
        return connection.getAdmin().tableExists(RSGROUP_TABLE_NAME);
    }

    public static List<RSGroupInfo> getAllRSGroupInfo(Connection connection) throws IOException {
        try (Table rsGroupTable = connection.getTable(RSGROUP_TABLE_NAME);){
            ArrayList<RSGroupInfo> rsGroupInfos = new ArrayList<RSGroupInfo>();
            for (Result result : rsGroupTable.getScanner(new Scan())) {
                RSGroupInfo rsGroupInfo = RSGroupTableAccessor.getRSGroupInfo(result);
                if (rsGroupInfo == null) continue;
                rsGroupInfos.add(rsGroupInfo);
            }
            ArrayList<RSGroupInfo> arrayList = rsGroupInfos;
            return arrayList;
        }
    }

    private static RSGroupInfo getRSGroupInfo(Result result) throws IOException {
        byte[] rsGroupInfo = result.getValue(META_FAMILY_BYTES, META_QUALIFIER_BYTES);
        if (rsGroupInfo == null) {
            return null;
        }
        RSGroupProtos.RSGroupInfo proto = RSGroupProtos.RSGroupInfo.parseFrom((byte[])rsGroupInfo);
        return ProtobufUtil.toGroupInfo(proto);
    }

    public static RSGroupInfo getRSGroupInfo(Connection connection, byte[] rsGroupName) throws IOException {
        try (Table rsGroupTable = connection.getTable(RSGROUP_TABLE_NAME);){
            Result result = rsGroupTable.get(new Get(rsGroupName));
            RSGroupInfo rSGroupInfo = RSGroupTableAccessor.getRSGroupInfo(result);
            return rSGroupInfo;
        }
    }
}

