/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.tez.dag.api.TezConfiguration;

@InterfaceAudience.Private
class AMConfiguration {
    private Map<String, LocalResource> amLocalResources = Maps.newHashMap();
    private TezConfiguration tezConf;
    private Credentials credentials;
    private LocalResource binaryConfLRsrc;

    AMConfiguration(TezConfiguration tezConf, Map<String, LocalResource> localResources, Credentials credentials) {
        this.tezConf = tezConf;
        if (localResources != null) {
            this.addAMLocalResources(localResources);
        }
        if (credentials != null) {
            this.setCredentials(credentials);
        }
    }

    void addAMLocalResources(Map<String, LocalResource> localResources) {
        this.amLocalResources.putAll(localResources);
    }

    void clearAMLocalResources() {
        this.amLocalResources.clear();
    }

    void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    void setTezConfiguration(TezConfiguration tezConf) {
        this.tezConf = tezConf;
    }

    String getQueueName() {
        return this.tezConf.get("tez.queue.name");
    }

    Map<String, LocalResource> getAMLocalResources() {
        return this.amLocalResources;
    }

    TezConfiguration getTezConfiguration() {
        return this.tezConf;
    }

    Credentials getCredentials() {
        return this.credentials;
    }

    void setBinaryConfLR(LocalResource binaryConfLRsrc) {
        this.binaryConfLRsrc = binaryConfLRsrc;
    }

    LocalResource getBinaryConfLR() {
        return this.binaryConfLRsrc;
    }
}

