/*
 * Decompiled with CFR 0.152.
 */
package junit.swingui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.swingui.TestRunner;
import junit.swingui.TestTreeModel;

class TestBrowser
extends JFrame
implements TestListener {
    private JButton fClose;
    private JButton fRun;
    private JButton fReload;
    private JTree fTree;
    private TestTreeModel fModel;
    private TestRunner fRunner;

    public TestBrowser(TestRunner testRunner) {
        this.fRunner = testRunner;
        this.getContentPane().setLayout(new GridBagLayout());
        ((Component)this).setBackground(SystemColor.control);
        ((Component)this).setSize(403, 300);
        this.setTitle("Test Browser");
        this.fTree = new JTree();
        this.fTree.setRowHeight(20);
        ToolTipManager.sharedInstance().registerComponent(this.fTree);
        this.fTree.putClientProperty("JTree.lineStyle", "Angled");
        JScrollPane jScrollPane = new JScrollPane(this.fTree);
        this.fClose = new JButton("Close");
        this.fClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestBrowser.this.dispose();
            }
        });
        this.fRun = new JButton("Run");
        this.fRun.setEnabled(false);
        this.fRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestBrowser.this.runSelection();
            }
        });
        this.fReload = new JButton("Reload");
        this.fReload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestBrowser.this.reloadTestTree();
            }
        });
        this.fTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TestBrowser.this.checkEnableRun(treeSelectionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.getContentPane().add((Component)jScrollPane, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(0, 8, 8, 8);
        this.getContentPane().add((Component)this.fRun, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.insets = new Insets(0, 8, 8, 8);
        this.getContentPane().add((Component)this.fReload, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridheight = 1;
        gridBagConstraints4.anchor = 13;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.weighty = 0.0;
        gridBagConstraints4.insets = new Insets(0, 8, 8, 8);
        this.getContentPane().add((Component)this.fClose, gridBagConstraints4);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TestBrowser.this.dispose();
            }
        });
    }

    public void addError(Test test, Throwable throwable) {
        this.fModel.addError(test);
        this.fireTestChanged(test, true);
    }

    public void addFailure(Test test, Throwable throwable) {
        this.fModel.addFailure(test);
        this.fireTestChanged(test, true);
    }

    public void checkEnableRun(TreeSelectionEvent treeSelectionEvent) {
        this.fRun.setEnabled(this.fTree.getSelectionCount() == 1);
    }

    public void endTest(Test test) {
        this.fModel.addRunTest(test);
        this.fireTestChanged(test, false);
    }

    private void fireTestChanged(final Test test, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Vector vector = new Vector();
                int n = fModel.findTest(test, (Test)fModel.getRoot(), vector);
                if (n >= 0) {
                    Object[] objectArray = new Object[vector.size()];
                    vector.copyInto(objectArray);
                    TreePath treePath = new TreePath(objectArray);
                    fModel.fireNodeChanged(treePath, n);
                    if (bl) {
                        Object object = fModel.getChild(treePath.getLastPathComponent(), n);
                        Object[] objectArray2 = new Object[vector.size() + 1];
                        vector.copyInto(objectArray2);
                        objectArray2[vector.size()] = object;
                        TreePath treePath2 = new TreePath(objectArray2);
                        fTree.scrollPathToVisible(treePath2);
                    }
                }
            }
        });
    }

    public TestListener getTestListener() {
        return this;
    }

    public void reloadTestTree() {
        Test test = this.fRunner.getTest(this.fRunner.getSuiteText());
        this.showTestTree(test);
    }

    public void runSelection() {
        this.fModel.resetResults();
        TreePath[] treePathArray = this.fTree.getSelectionPaths();
        int n = 0;
        while (n < treePathArray.length) {
            TreePath treePath = treePathArray[n];
            this.fRunner.runTest((Test)treePath.getLastPathComponent());
            ++n;
        }
    }

    public void showTestTree(Test test) {
        this.fModel = new TestTreeModel(test);
        this.fTree.setModel(this.fModel);
        this.fTree.setCellRenderer(new TestTreeCellRenderer());
    }

    public void startTest(Test test) {
    }

    static class TestTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon fErrorIcon;
        private ImageIcon fOkIcon;
        private ImageIcon fFailureIcon;

        TestTreeCellRenderer() {
            URL uRL = this.getClass().getResource("error.gif");
            this.fErrorIcon = new ImageIcon(uRL);
            uRL = this.getClass().getResource("ok.gif");
            this.fOkIcon = new ImageIcon(uRL);
            uRL = this.getClass().getResource("failure.gif");
            this.fFailureIcon = new ImageIcon(uRL);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            TreeModel treeModel = jTree.getModel();
            if (treeModel instanceof TestTreeModel) {
                TestTreeModel testTreeModel = (TestTreeModel)treeModel;
                Test test = (Test)object;
                String string = "";
                if (testTreeModel.isFailure(test)) {
                    this.setIcon(this.fFailureIcon);
                    string = " - Failed";
                } else if (testTreeModel.isError(test)) {
                    this.setIcon(this.fErrorIcon);
                    string = " - Error";
                } else if (testTreeModel.wasRun(test)) {
                    this.setIcon(this.fOkIcon);
                    string = " - Passed";
                }
                if (component instanceof JComponent) {
                    ((JComponent)component).setToolTipText(String.valueOf(this.getText()) + string);
                }
            }
            return component;
        }
    }
}

