/*
 * Decompiled with CFR 0.152.
 */
package junit.ui;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageProducer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.ui.AboutDialog;
import junit.ui.Logo;
import junit.ui.ProgressBar;
import junit.ui.TraceFrame;
import junit.util.StandardTestSuiteLoader;
import junit.util.StringUtil;
import junit.util.TestSuiteLoader;

public class TestRunner
implements TestListener {
    private Frame fFrame;
    private Vector fExceptions;
    private Vector fFailedTests;
    private Thread fRunner;
    private TestResult fTestResult;
    private TestSuiteLoader fTestLoader;
    private TraceFrame fTraceFrame;
    private TextField fSuiteField;
    private Button fRun;
    private ProgressBar fProgressIndicator;
    private List fFailureList;
    private Logo fLogo;
    private Label fNumberOfErrors;
    private Label fNumberOfFailures;
    private Label fNumberOfRuns;
    private Button fQuitButton;
    private Button fShowErrorButton;
    private Button fRerunButton;
    private TextField fStatusLine;
    private Panel fPanel;
    private static Font PLAIN_FONT = new Font("dialog", 0, 12);
    private static final int GAP = 4;
    private static final String SUITE_METHODNAME = "suite";
    static /* synthetic */ Class class$java$lang$String;

    private void about() {
        AboutDialog aboutDialog = new AboutDialog(this.fFrame);
        aboutDialog.setModal(true);
        ((Component)aboutDialog).setLocation(300, 300);
        ((Component)aboutDialog).setVisible(true);
    }

    static /* synthetic */ Thread access$14(TestRunner testRunner) {
        return testRunner.fRunner;
    }

    public void addError(Test test, Throwable throwable) {
        this.fNumberOfErrors.setText(Integer.toString(this.fTestResult.errorCount()));
        this.appendFailure("Error", test, throwable);
    }

    public void addFailure(Test test, Throwable throwable) {
        this.fNumberOfFailures.setText(Integer.toString(this.fTestResult.failureCount()));
        this.appendFailure("Failure", test, throwable);
    }

    private void addGrid(Panel panel, Component component, int n, int n2, int n3, int n4, double d, int n5) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.weightx = d;
        gridBagConstraints.fill = n4;
        if (n4 == 1 || n4 == 3) {
            gridBagConstraints.weighty = 1.0;
        }
        gridBagConstraints.insets = new Insets(n2 == 0 ? 4 : 0, n == 0 ? 4 : 0, 4, 4);
        panel.add(component, gridBagConstraints);
    }

    private void appendFailure(String string, Test test, Throwable throwable) {
        string = String.valueOf(string) + ": " + test;
        String string2 = throwable.getMessage();
        if (string2 != null) {
            string = String.valueOf(string) + ":" + StringUtil.truncate(string2, 100);
        }
        this.fFailureList.add(string);
        this.fExceptions.addElement(throwable);
        this.fFailedTests.addElement(test);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Menu createJUnitMenu() {
        Menu menu = new Menu("JUnit");
        MenuItem menuItem = new MenuItem("About...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.about();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new MenuItem("Exit");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        menu.add(menuItem);
        return menu;
    }

    protected void createMenus(MenuBar menuBar) {
        menuBar.add(this.createJUnitMenu());
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected Frame createUI(String string) {
        Panel panel;
        Frame frame = new Frame("Run Test Suite");
        Image image = this.loadFrameIcon();
        if (image != null) {
            frame.setIconImage(image);
        }
        frame.setLayout(new BorderLayout(0, 0));
        ((Component)frame).setBackground(SystemColor.control);
        final Frame frame2 = frame;
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                frame2.dispose();
                System.exit(0);
            }
        });
        MenuBar menuBar = new MenuBar();
        this.createMenus(menuBar);
        frame.setMenuBar(menuBar);
        Label label = new Label("Enter the name of the TestCase class:");
        this.fSuiteField = new TextField(string != null ? string : "");
        this.fSuiteField.selectAll();
        this.fSuiteField.requestFocus();
        this.fSuiteField.setFont(PLAIN_FONT);
        this.fSuiteField.setColumns(40);
        this.fSuiteField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.runSuite();
            }
        });
        this.fSuiteField.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent textEvent) {
                TestRunner.this.fRun.setEnabled(TestRunner.this.fSuiteField.getText().length() > 0);
                TestRunner.this.fStatusLine.setText("");
            }
        });
        Label label2 = new Label(".suite()");
        this.fRun = new Button("Run");
        this.fRun.setEnabled(false);
        this.fRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.runSuite();
            }
        });
        Label label3 = new Label("Progress:");
        this.fProgressIndicator = new ProgressBar();
        this.fNumberOfErrors = new Label("0000", 2);
        this.fNumberOfErrors.setText("0");
        this.fNumberOfErrors.setFont(PLAIN_FONT);
        this.fNumberOfFailures = new Label("0000", 2);
        this.fNumberOfFailures.setText("0");
        this.fNumberOfFailures.setFont(PLAIN_FONT);
        this.fNumberOfRuns = new Label("0000", 2);
        this.fNumberOfRuns.setText("0");
        this.fNumberOfRuns.setFont(PLAIN_FONT);
        Panel panel2 = new Panel(new FlowLayout());
        panel2.add(new Label("Runs:"));
        panel2.add(this.fNumberOfRuns);
        panel2.add(new Label("   Errors:"));
        panel2.add(this.fNumberOfErrors);
        panel2.add(new Label("   Failures:"));
        panel2.add(this.fNumberOfFailures);
        Label label4 = new Label("Errors and Failures:");
        this.fFailureList = new List(6);
        this.fFailureList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    TestRunner.this.showErrorTrace();
                }
            }
        });
        this.fFailureList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TestRunner.this.fShowErrorButton.setEnabled(TestRunner.this.isErrorSelected());
                TestRunner.this.fRerunButton.setEnabled(TestRunner.this.isErrorSelected());
            }
        });
        this.fShowErrorButton = new Button("Show...");
        this.fShowErrorButton.setEnabled(false);
        this.fShowErrorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.showErrorTrace();
            }
        });
        this.fRerunButton = new Button("Run");
        this.fRerunButton.setEnabled(false);
        this.fRerunButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.rerun();
            }
        });
        Panel panel3 = new Panel(new GridLayout(0, 1, 0, 2));
        panel3.add(this.fShowErrorButton);
        panel3.add(this.fRerunButton);
        this.fStatusLine = new TextField();
        this.fStatusLine.setFont(PLAIN_FONT);
        this.fStatusLine.setEditable(false);
        this.fStatusLine.setForeground(Color.red);
        this.fQuitButton = new Button("Exit");
        this.fQuitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.fLogo = new Logo();
        this.fPanel = panel = new Panel(new GridBagLayout());
        this.addGrid(panel, label, 0, 0, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fSuiteField, 0, 1, 1, 2, 1.0, 17);
        this.addGrid(panel, label2, 1, 1, 1, 0, 0.0, 17);
        this.addGrid(panel, this.fRun, 2, 1, 1, 2, 0.0, 10);
        this.addGrid(panel, label3, 0, 2, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fProgressIndicator, 0, 3, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fLogo, 2, 3, 1, 0, 0.0, 11);
        this.addGrid(panel, panel2, 0, 4, 2, 0, 0.0, 10);
        this.addGrid(panel, label4, 0, 5, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fFailureList, 0, 6, 2, 1, 1.0, 17);
        this.addGrid(panel, panel3, 2, 6, 1, 2, 0.0, 10);
        this.addGrid(panel, this.fStatusLine, 0, 7, 2, 2, 1.0, 10);
        this.addGrid(panel, this.fQuitButton, 2, 7, 1, 2, 0.0, 10);
        frame.add(panel);
        frame.pack();
        return frame;
    }

    public void endTest(Test test) {
        this.setLabelValue(this.fNumberOfRuns, this.fTestResult.runCount());
        this.fProgressIndicator.step(this.fTestResult.wasSuccessful());
    }

    private Test getTest(String string) {
        if (string.length() <= 0) {
            this.fStatusLine.setText("");
            return null;
        }
        Class clazz = null;
        try {
            clazz = this.loadSuiteClass(string);
        }
        catch (Exception exception) {
            this.runFailed("Class \"" + string + "\" not found");
            return null;
        }
        Method method = null;
        try {
            method = clazz.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception exception) {
            this.fStatusLine.setText("");
            return new TestSuite(clazz);
        }
        Test test = null;
        try {
            test = (Test)method.invoke(null, (Object[])new Class[0]);
            if (test == null) {
                return test;
            }
        }
        catch (Exception exception) {
            this.runFailed("Could not invoke the suite() method");
            return null;
        }
        this.fStatusLine.setText("");
        return test;
    }

    private boolean isErrorSelected() {
        return this.fFailureList.getSelectedIndex() != -1;
    }

    private Image loadFrameIcon() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URL uRL = this.getClass().getResource("smalllogo.gif");
            return toolkit.createImage((ImageProducer)uRL.getContent());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Class loadSuiteClass(String string) throws ClassNotFoundException {
        return this.fTestLoader.load(string);
    }

    public static void main(String[] stringArray) {
        new TestRunner().start(stringArray, new StandardTestSuiteLoader());
    }

    private void rerun() {
        Object object;
        Object object2;
        int n = this.fFailureList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        Test test = (Test)this.fFailedTests.elementAt(n);
        if (!(test instanceof TestCase)) {
            this.showInfo("Could not reload " + test.toString());
            return;
        }
        Test test2 = null;
        try {
            object2 = this.fTestLoader.reload(test.getClass());
            object = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = TestRunner.class$("java.lang.String"))};
            Constructor constructor = ((Class)object2).getConstructor((Class<?>)object);
            Object[] objectArray = new Object[]{((TestCase)test).name()};
            test2 = (Test)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            this.showInfo("Could not reload " + test.toString());
            return;
        }
        object2 = new TestResult();
        test2.run((TestResult)object2);
        object = test2.toString();
        if (((TestResult)object2).wasSuccessful()) {
            this.showInfo(String.valueOf(object) + " was successful");
        } else if (((TestResult)object2).errorCount() == 1) {
            this.showStatus(String.valueOf(object) + " had an error");
        } else {
            this.showStatus(String.valueOf(object) + " had a failure");
        }
    }

    protected void reset() {
        this.setLabelValue(this.fNumberOfErrors, 0);
        this.setLabelValue(this.fNumberOfFailures, 0);
        this.setLabelValue(this.fNumberOfRuns, 0);
        this.fProgressIndicator.reset();
        this.fShowErrorButton.setEnabled(false);
        this.fRerunButton.setEnabled(false);
        this.fFailureList.removeAll();
        this.fExceptions = new Vector(10);
        this.fFailedTests = new Vector(10);
    }

    public void run() {
        this.runSuite();
    }

    private void runFailed(String string) {
        this.showStatus(string);
        this.fRun.setLabel("Run");
        this.fRunner = null;
    }

    public synchronized void runSuite() {
        if (this.fRunner != null) {
            this.fTestResult.stop();
        } else {
            this.fRun.setLabel("Stop");
            this.showInfo("Initializing...");
            this.reset();
            this.showInfo("Load Test Case...");
            final Test test = this.getTest(this.fSuiteField.getText());
            if (test != null) {
                this.fRunner = new Thread(){

                    public void run() {
                        fTestResult = this.createTestResult();
                        fTestResult.addListener(this);
                        fProgressIndicator.start(test.countTestCases());
                        this.showInfo("Running...");
                        long l = System.currentTimeMillis();
                        test.run(fTestResult);
                        if (fTestResult.shouldStop()) {
                            this.showStatus("Stopped");
                        } else {
                            long l2 = System.currentTimeMillis();
                            long l3 = l2 - l;
                            this.showInfo("Finished: " + StringUtil.elapsedTimeAsString(l3) + " seconds");
                        }
                        fTestResult = null;
                        fRun.setLabel("Run");
                        fRunner = null;
                    }
                };
                this.fRunner.start();
            }
        }
    }

    private void setLabelValue(Label label, int n) {
        label.setText(Integer.toString(n));
    }

    public void setSuiteName(String string) {
        this.fSuiteField.setText(string);
    }

    private void showErrorTrace() {
        int n = this.fFailureList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        Throwable throwable = (Throwable)this.fExceptions.elementAt(n);
        if (this.fTraceFrame == null) {
            this.fTraceFrame = new TraceFrame();
            ((Component)this.fTraceFrame).setLocation(100, 100);
        }
        this.fTraceFrame.showTrace(throwable);
        ((Component)this.fTraceFrame).setVisible(true);
    }

    private void showInfo(String string) {
        this.fStatusLine.setFont(PLAIN_FONT);
        this.fStatusLine.setForeground(Color.black);
        this.fStatusLine.setText(string);
    }

    private void showStatus(String string) {
        this.fStatusLine.setFont(PLAIN_FONT);
        this.fStatusLine.setForeground(Color.red);
        this.fStatusLine.setText(string);
    }

    public void start(String[] stringArray, TestSuiteLoader testSuiteLoader) {
        this.fTestLoader = testSuiteLoader;
        String string = null;
        if (stringArray.length == 1) {
            string = stringArray[0];
        } else if (stringArray.length == 2 && stringArray[0].equals("-c")) {
            string = StringUtil.extractClassName(stringArray[1]);
        }
        this.fFrame = this.createUI(string);
        ((Component)this.fFrame).setLocation(200, 200);
        ((Component)this.fFrame).setVisible(true);
        if (string != null) {
            this.setSuiteName(string);
            this.runSuite();
        }
    }

    public void startTest(Test test) {
        this.showInfo("Running: " + test);
    }
}

