/*
 * Decompiled with CFR 0.152.
 */
package sdsu.logging;

import java.util.Hashtable;
import java.util.Properties;
import sdsu.logging.DebugMessage;
import sdsu.logging.ErrorMessage;
import sdsu.logging.LogMessage;
import sdsu.logging.LoggerImplementation;
import sdsu.logging.LoggerMessage;
import sdsu.logging.ScreenLogger;
import sdsu.logging.WarningMessage;

public class Logger {
    private static boolean hasBeenSet = false;
    private static LoggerImplementation activeLogger = new ScreenLogger();

    public static void debug(String string) {
        Logger.log(new DebugMessage(string, 1));
    }

    public static void error(Exception exception) {
        Logger.log(new ErrorMessage(exception));
    }

    public static void error(String string) {
        Logger.log(new ErrorMessage(string));
    }

    public static LoggerImplementation getLogger() {
        return activeLogger;
    }

    public static boolean hasLogger() {
        return hasBeenSet;
    }

    public static void log(String string) {
        Logger.log(new LogMessage(string));
    }

    public static void log(LoggerMessage loggerMessage) {
        activeLogger.log(loggerMessage);
    }

    private static void preventClassGarbageCollection() {
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("_$sdsu.logging.Logger.instance", new Logger());
    }

    public static void register(LoggerImplementation loggerImplementation) {
        if (!hasBeenSet) {
            activeLogger = loggerImplementation;
            hasBeenSet = true;
            Logger.preventClassGarbageCollection();
        }
    }

    public static void reset() {
        activeLogger.reset();
    }

    public static void warning(String string) {
        Logger.log(new WarningMessage(string));
    }
}

