/*
 * Decompiled with CFR 0.152.
 */
package sdsu.util;

public final class CharQueue {
    private char[] queueElements;
    private int queueFront;
    private int queueRear;
    private int elementCount;
    public static final int DEFAULT_QUEUE_SIZE = 256;

    public CharQueue() {
        this(256);
    }

    public CharQueue(int n) {
        this.queueElements = new char[n];
        this.queueFront = 0;
        this.queueRear = 0;
        this.elementCount = 0;
    }

    public int capacity() {
        return this.queueElements.length;
    }

    public void clear() {
        this.queueFront = 0;
        this.queueRear = 0;
        this.elementCount = 0;
    }

    public char dequeue() {
        char c = this.queueElements[this.queueFront];
        this.queueFront = (this.queueFront + 1) % this.capacity();
        --this.elementCount;
        return c;
    }

    public int dequeue(char[] cArray) {
        return this.dequeue(cArray, 0, cArray.length);
    }

    public int dequeue(char[] cArray, int n, int n2) {
        int n3 = Math.min(n2, this.elementCount);
        int n4 = this.capacity() - this.queueFront;
        if (n4 >= n3) {
            System.arraycopy(this.queueElements, this.queueFront, cArray, n, n3);
        } else {
            System.arraycopy(this.queueElements, this.queueFront, cArray, n, n4);
            System.arraycopy(this.queueElements, 0, cArray, n + n4, n3 - n4);
        }
        this.queueFront = (this.queueFront + n3) % this.capacity();
        this.elementCount -= n3;
        return n3;
    }

    public char[] dequeueAll() {
        char[] cArray = new char[this.elementCount];
        this.dequeue(cArray);
        return cArray;
    }

    public void enqueue(char c) {
        if (this.isFull()) {
            this.grow();
        }
        this.queueElements[this.queueRear] = c;
        this.queueRear = (this.queueRear + 1) % this.capacity();
        ++this.elementCount;
    }

    public void enqueue(String string) {
        this.enqueue(string.toCharArray());
    }

    public void enqueue(char[] cArray) {
        this.enqueue(cArray, 0, cArray.length);
    }

    public void enqueue(char[] cArray, int n, int n2) {
        int n3;
        if (n2 > this.unusedCapacity()) {
            this.grow(Math.max(n2 + 32, this.capacity() * 2));
        }
        if ((n3 = this.capacity() - this.queueRear) >= n2) {
            System.arraycopy(cArray, n, this.queueElements, this.queueRear, n2);
        } else {
            System.arraycopy(cArray, n, this.queueElements, this.queueRear, n3);
            System.arraycopy(cArray, n + n3, this.queueElements, 0, n2 - n3);
        }
        this.queueRear = (this.queueRear + n2) % this.capacity();
        this.elementCount += n2;
    }

    private void grow() {
        if (this.capacity() <= 16) {
            this.grow(32);
        } else if (this.capacity() <= 1024) {
            this.grow(this.capacity() * 2);
        } else {
            this.grow((int)((double)this.capacity() * 1.5));
        }
    }

    private void grow(int n) {
        char[] cArray = new char[n];
        if (this.queueFront < this.queueRear) {
            System.arraycopy(this.queueElements, this.queueFront, cArray, 0, this.elementCount);
        } else {
            int n2 = this.capacity() - this.queueFront;
            System.arraycopy(this.queueElements, this.queueFront, cArray, 0, n2);
            System.arraycopy(this.queueElements, 0, cArray, n2, this.queueRear);
        }
        this.queueElements = cArray;
        this.queueFront = 0;
        this.queueRear = this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public boolean isFull() {
        return this.elementCount >= this.capacity();
    }

    public char peek() {
        return this.queueElements[this.queueFront];
    }

    public int size() {
        return this.elementCount;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.elementCount);
        if (this.queueFront < this.queueRear) {
            stringBuffer.append(this.queueElements, this.queueFront, this.elementCount);
        } else {
            int n = this.capacity() - this.queueFront;
            stringBuffer.append(this.queueElements, this.queueFront, n);
            stringBuffer.append(this.queueElements, 0, this.queueRear);
        }
        return stringBuffer.toString();
    }

    public int unusedCapacity() {
        return this.capacity() - this.size();
    }
}

