/*
 * Decompiled with CFR 0.152.
 */
package sdsu.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import sdsu.io.LocalRepository;
import sdsu.util.LabeledData;

public class ProgramProperties {
    private static final String FILE_OPTIONS_KEY = "conf";
    LabeledData flags = new LabeledData();
    Properties fileOptions = new Properties();

    public ProgramProperties(String string) throws IOException {
        this.fileOptions = this.getFileOptions(string);
    }

    public ProgramProperties(String[] stringArray) throws IOException {
        this(stringArray, null);
    }

    public ProgramProperties(String[] stringArray, String string) throws IOException {
        this.flags.fromCommandLine(stringArray);
        this.fileOptions = this.getFileOptions(string);
    }

    protected ProgramProperties(String[] stringArray, String string, boolean bl) throws IOException {
        this.flags.fromCommandLine(stringArray);
        try {
            this.fileOptions = this.getFileOptions(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.fileOptions = new Properties();
        }
    }

    public boolean containsKey(String string) {
        return ((Hashtable)this.flags).containsKey(string) || ((Hashtable)this.fileOptions).containsKey(string);
    }

    public static ProgramProperties fileOptional(String[] stringArray, String string) throws IOException {
        return new ProgramProperties(stringArray, string, true);
    }

    private Properties getFileOptions(String string) throws IOException {
        String string2;
        LocalRepository localRepository;
        Properties properties;
        if ((string = this.flags.getData(FILE_OPTIONS_KEY, string)) == null) {
            return new Properties();
        }
        if (string.length() <= 0) {
            return new Properties();
        }
        if (string.toLowerCase().endsWith(".properties")) {
            Properties properties2 = new Properties();
            properties2.load(new BufferedInputStream(new FileInputStream(string)));
            return properties2;
        }
        if (string.toLowerCase().endsWith(".labeleddata")) {
            LabeledData labeledData = new LabeledData();
            ((Properties)labeledData).load(new BufferedInputStream(new FileInputStream(string)));
            return labeledData;
        }
        File file = new File(string);
        String string3 = file.getParent();
        if (string3 == null) {
            string3 = ".";
        }
        if ((properties = (Properties)(localRepository = new LocalRepository(string3)).get(string2 = file.getName())) == null) {
            throw new FileNotFoundException("Could not find file: " + string);
        }
        return properties;
    }

    public float getFloat(String string) throws NumberFormatException {
        String string2 = this.getString(string, null);
        return Float.valueOf(string2).floatValue();
    }

    public float getFloat(String string, float f) throws NumberFormatException {
        String string2 = this.getString(string, null);
        if (string2 == null) {
            return f;
        }
        return Float.valueOf(string2).floatValue();
    }

    public int getInt(String string) throws NumberFormatException {
        String string2 = this.getString(string, null);
        return Integer.valueOf(string2);
    }

    public int getInt(String string, int n) throws NumberFormatException {
        String string2 = this.getString(string, null);
        if (string2 == null) {
            return n;
        }
        return Integer.valueOf(string2);
    }

    public String getString(String string) {
        return this.getString(string, null);
    }

    public String getString(String string, String string2) {
        if (((Hashtable)this.flags).containsKey(string)) {
            return this.flags.getData(string);
        }
        if (((Hashtable)this.fileOptions).containsKey(string)) {
            return this.fileOptions.getProperty(string);
        }
        return string2;
    }
}

