/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MetricsTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.lib.MutableSizeHistogram;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetricsTests.class, SmallTests.class})
public class TestMutableRangeHistogram {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMutableRangeHistogram.class);
    private static final String RECORD_NAME = "test";
    private static final String SIZE_HISTOGRAM_NAME = "TestSize";

    @Test
    public void testLastBucketWithSizeHistogram() {
        MetricsCollectorImpl collector = new MetricsCollectorImpl();
        MutableSizeHistogram histogram = new MutableSizeHistogram(SIZE_HISTOGRAM_NAME, "");
        long[] ranges = histogram.getRanges();
        int len = ranges.length;
        histogram.add(0L);
        histogram.add(ranges[len - 1]);
        histogram.snapshot((MetricsRecordBuilder)collector.addRecord(RECORD_NAME), true);
        collector.clear();
        histogram.add(ranges[len - 2] * 2L);
        histogram.add(ranges[len - 1] * 2L);
        histogram.snapshot((MetricsRecordBuilder)collector.addRecord(RECORD_NAME), true);
        List records = collector.getRecords();
        Assert.assertEquals((long)1L, (long)records.size());
        MetricsRecord record = (MetricsRecord)records.iterator().next();
        Assert.assertEquals((Object)RECORD_NAME, (Object)record.name());
        String histogramMetricPrefix = "TestSize_" + histogram.getRangeType();
        ArrayList<AbstractMetric> metrics = new ArrayList<AbstractMetric>();
        for (AbstractMetric metric : record.metrics()) {
            if (!metric.name().startsWith(histogramMetricPrefix)) continue;
            metrics.add(metric);
        }
        Assert.assertEquals((long)2L, (long)metrics.size());
        String metricName = histogramMetricPrefix + "_" + ranges[len - 2] + "-" + ranges[len - 1];
        Assert.assertEquals((Object)metricName, (Object)((AbstractMetric)metrics.get(0)).name());
        Assert.assertEquals((long)1L, (long)((AbstractMetric)metrics.get(0)).value().longValue());
        metricName = histogramMetricPrefix + "_" + ranges[len - 1] + "-inf";
        Assert.assertEquals((String)metricName, (Object)((AbstractMetric)metrics.get(1)).name(), (Object)metricName);
        Assert.assertEquals((long)1L, (long)((AbstractMetric)metrics.get(1)).value().longValue());
    }
}

