/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Hashtable;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.MDC;
import org.apache.log4j.helpers.ThreadLocalMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingUtils.class);

    private LoggingUtils() {
    }

    public static void initLoggingContext(ThreadLocalMap threadLocalMap, Configuration conf, String dagId, String taskAttemptId) {
        NonClonableHashtable<String, String> data = (NonClonableHashtable<String, String>)threadLocalMap.get();
        if (data == null) {
            data = new NonClonableHashtable<String, String>();
            threadLocalMap.set(data);
        }
        data.put("dagId", dagId == null ? "" : dagId);
        data.put("taskAttemptId", taskAttemptId == null ? "" : taskAttemptId);
        String[] mdcKeys = conf.getStrings("tez.mdc.custom.keys");
        if (mdcKeys == null || mdcKeys.length == 0) {
            return;
        }
        String[] mdcKeysValuesFrom = conf.getStrings("tez.mdc.custom.keys.conf.props");
        LOG.info("MDC_LOGGING: setting up MDC keys: keys: {} / conf: {}", Arrays.asList(mdcKeys), Arrays.asList(mdcKeysValuesFrom));
        int i = 0;
        for (String mdcKey : mdcKeys) {
            String mdcValue;
            if (mdcKey.isEmpty() || mdcKeysValuesFrom.length < i + 1) {
                LOG.warn("cannot set mdc key: {}", (Object)mdcKey);
                break;
            }
            String string = mdcValue = mdcKeysValuesFrom[i] == null ? "" : conf.get(mdcKeysValuesFrom[i]);
            if (mdcValue != null) {
                data.put(mdcKey, mdcValue);
            } else {
                LOG.warn("MDC_LOGGING: mdc value is null for key: {}, config key: {}", (Object)mdcKey, (Object)mdcKeysValuesFrom[i]);
            }
            ++i;
        }
    }

    public static String getPatternForAM(Configuration conf) {
        String pattern = conf.get("tez.am.log.pattern.layout", "");
        return pattern.isEmpty() ? null : pattern;
    }

    public static String getPatternForTask(Configuration conf) {
        String pattern = conf.get("tez.task.log.pattern.layout", "");
        return pattern.isEmpty() ? null : pattern;
    }

    public static ThreadLocalMap setupLog4j() {
        ThreadLocalMap mdcContext = new ThreadLocalMap();
        mdcContext.set(new NonClonableHashtable());
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> c : constructors = MDC.class.getDeclaredConstructors()) {
                c.setAccessible(true);
            }
            MDC mdc = (MDC)constructors[0].newInstance(new Object[0]);
            Field tlmField = MDC.class.getDeclaredField("tlm");
            tlmField.setAccessible(true);
            tlmField.set(mdc, mdcContext);
            Field mdcField = MDC.class.getDeclaredField("mdc");
            mdcField.setAccessible(true);
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(mdcField, mdcField.getModifiers() & 0xFFFFFFEF);
            mdcField.set(null, mdc);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot set log4j global MDC, mdcContext won't be applied to log4j's MDC class", (Throwable)e);
            }
            LOG.warn("Cannot set log4j global MDC, mdcContext won't be applied to log4j's MDC class: {}", (Object)e.getMessage());
        }
        return mdcContext;
    }

    private static class NonClonableHashtable<K, V>
    extends Hashtable<String, String> {
        private static final long serialVersionUID = 1L;

        private NonClonableHashtable() {
        }

        @Override
        public synchronized Object clone() {
            return this;
        }
    }
}

