/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.impl.plan.PlanException;

public class NoopFilterRemoverUtil {
    private static Log log = LogFactory.getLog(NoopFilterRemoverUtil.class);

    public static void removeFilter(POFilter filter, PhysicalPlan plan) {
        if (plan.size() > 1) {
            try {
                List<PhysicalOperator> fInputs = filter.getInputs();
                List<POFilter> sucs = plan.getSuccessors(filter);
                plan.removeAndReconnect(filter);
                if (sucs != null && sucs.size() != 0) {
                    for (PhysicalOperator physicalOperator : sucs) {
                        physicalOperator.setInputs(fInputs);
                    }
                }
            }
            catch (PlanException pe) {
                log.info((Object)("Couldn't remove a filter in optimizer: " + pe.getMessage()));
            }
        }
    }
}

