/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.ObjectCache;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.data.SchemaTupleBackend;
import org.apache.pig.data.SchemaTupleClassGenerator;
import org.apache.pig.data.SchemaTupleFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class POFRJoinTez
extends POFRJoin
implements TezInput {
    private static final Log log = LogFactory.getLog(POFRJoinTez.class);
    private static final long serialVersionUID = 1L;
    private List<String> inputKeys;
    private transient List<LogicalInput> replInputs;
    private transient List<KeyValueReader> replReaders;
    private transient boolean isInputCached;
    private transient String cacheKey;

    public POFRJoinTez(POFRJoin copy, List<String> inputKeys) throws ExecException {
        super(copy);
        this.inputKeys = inputKeys;
    }

    @Override
    public String[] getTezInputs() {
        return this.inputKeys.toArray(new String[this.inputKeys.size()]);
    }

    @Override
    public void replaceInput(String oldInputKey, String newInputKey) {
        while (this.inputKeys.remove(oldInputKey)) {
            this.inputKeys.add(newInputKey);
        }
    }

    @Override
    public void addInputsToSkip(Set<String> inputsToSkip) {
        this.cacheKey = "replicatemap-" + this.inputKeys.toString();
        Object cacheValue = ObjectCache.getInstance().retrieve(this.cacheKey);
        if (cacheValue != null) {
            this.isInputCached = true;
            inputsToSkip.addAll(this.inputKeys);
        }
    }

    @Override
    public void attachInputs(Map<String, LogicalInput> inputs, Configuration conf) throws ExecException {
        if (this.isInputCached) {
            return;
        }
        try {
            this.replInputs = Lists.newArrayList();
            this.replReaders = Lists.newArrayList();
            for (String key : this.inputKeys) {
                LogicalInput input = inputs.get(key);
                if (this.replInputs.contains(input)) continue;
                this.replInputs.add(input);
                KeyValueReader reader = (KeyValueReader)input.getReader();
                this.replReaders.add(reader);
                log.info((Object)("Attached input from vertex " + key + " : input=" + input + ", reader=" + reader));
            }
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
    }

    @Override
    protected void setUpHashMap() throws ExecException {
        Object cacheValue = ObjectCache.getInstance().retrieve(this.cacheKey);
        if (cacheValue != null) {
            this.replicates = (List)cacheValue;
            log.info((Object)("Found " + (this.replicates.size() - 1) + " replication hash tables in Tez cache. cachekey=" + this.cacheKey));
            return;
        }
        log.info((Object)"Building replication hash table");
        SchemaTupleFactory[] inputSchemaTupleFactories = new SchemaTupleFactory[this.inputSchemas.length];
        SchemaTupleFactory[] keySchemaTupleFactories = new SchemaTupleFactory[this.inputSchemas.length];
        for (int i = 0; i < this.inputSchemas.length; ++i) {
            Schema schema = this.inputSchemas[i];
            if (schema != null) {
                log.debug((Object)("Using SchemaTuple for FR Join Schema: " + schema));
                inputSchemaTupleFactories[i] = SchemaTupleBackend.newSchemaTupleFactory(schema, false, SchemaTupleClassGenerator.GenContext.FR_JOIN);
            }
            if ((schema = this.keySchemas[i]) == null) continue;
            log.debug((Object)("Using SchemaTuple for FR Join key Schema: " + schema));
            keySchemaTupleFactories[i] = SchemaTupleBackend.newSchemaTupleFactory(schema, false, SchemaTupleClassGenerator.GenContext.FR_JOIN);
        }
        long time1 = System.currentTimeMillis();
        this.replicates.set(this.fragment, null);
        int inputIdx = 0;
        int schemaIdx = 1;
        while (inputIdx < this.replInputs.size()) {
            SchemaTupleFactory inputSchemaTupleFactory = inputSchemaTupleFactories[schemaIdx];
            SchemaTupleFactory keySchemaTupleFactory = keySchemaTupleFactories[schemaIdx];
            POFRJoin.TupleToMapKey replicate = keySchemaTupleFactory == null ? new HashMap(4000) : new POFRJoin.TupleToMapKey(4000, keySchemaTupleFactory);
            POLocalRearrange lr = this.LRs[schemaIdx];
            try {
                while (this.replReaders.get(inputIdx).next()) {
                    PigNullableWritable key;
                    Object keyValue;
                    if (POFRJoinTez.getReporter() != null) {
                        POFRJoinTez.getReporter().progress();
                    }
                    if (this.isKeyNull(keyValue = (key = (PigNullableWritable)this.replReaders.get(inputIdx).getCurrentKey()).getValueAsPigType())) continue;
                    NullableTuple val = (NullableTuple)this.replReaders.get(inputIdx).getCurrentValue();
                    Tuple retTuple = mTupleFactory.newTuple(3);
                    retTuple.set(0, key.getIndex());
                    retTuple.set(1, keyValue);
                    retTuple.set(2, val.getValueAsPigType());
                    Tuple valTuple = this.getValueTuple(lr, retTuple);
                    POMergeJoin.TuplesToSchemaTupleList values = (POMergeJoin.TuplesToSchemaTupleList)replicate.get(keyValue);
                    if (values == null) {
                        values = inputSchemaTupleFactory == null ? new ArrayList(1) : new POMergeJoin.TuplesToSchemaTupleList(1, inputSchemaTupleFactory);
                        replicate.put(keyValue, values);
                    }
                    ((ArrayList)values).add(valTuple);
                }
            }
            catch (IOException e) {
                throw new ExecException(e);
            }
            this.replicates.set(schemaIdx, replicate);
            ++inputIdx;
            ++schemaIdx;
        }
        long time2 = System.currentTimeMillis();
        log.info((Object)(this.replicates.size() - 1 + " replication hash tables built. Time taken: " + (time2 - time1)));
        ObjectCache.getInstance().cache(this.cacheKey, this.replicates);
        log.info((Object)("Cached replicate hash tables in Tez ObjectRegistry with vertex scope. cachekey=" + this.cacheKey));
    }

    @Override
    public String name() {
        StringBuffer inputs = new StringBuffer();
        for (int i = 0; i < this.inputKeys.size(); ++i) {
            if (i > 0) {
                inputs.append(",");
            }
            inputs.append(this.inputKeys.get(i));
        }
        return super.name() + "\t<-\t " + inputs.toString();
    }

    public List<String> getInputKeys() {
        return this.inputKeys;
    }

    @Override
    public POFRJoinTez clone() throws CloneNotSupportedException {
        return (POFRJoinTez)super.clone();
    }
}

