/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.Algebraic;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POCast;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;

public class UDFContextSeparator
extends PhyPlanVisitor {
    private String planOpKey;
    private DepthFirstWalker<PhysicalOperator, PhysicalPlan> dfw = new DepthFirstWalker(null);
    private Map<String, Map<Enum<UDFType>, List<UDFContext.UDFContextKey>>> udfContextsPerPlan;
    private UDFContext udfContext = UDFContext.getUDFContext();
    private Set<UDFContext.UDFContextKey> allKeys = this.udfContext.getUdfConfs().keySet();
    private Set<UDFContext.UDFContextKey> knownKeys = new HashSet<UDFContext.UDFContextKey>();
    private Set<UDFContext.UDFContextKey> unKnownKeys;
    private Set<UDFContext.UDFContextKey> algebraicUDFKeys = new HashSet<UDFContext.UDFContextKey>();

    public UDFContextSeparator() {
        super(null, null);
        this.udfContextsPerPlan = new HashMap<String, Map<Enum<UDFType>, List<UDFContext.UDFContextKey>>>();
    }

    public Set<UDFContext.UDFContextKey> getUnKnownKeys() {
        if (this.unKnownKeys == null) {
            this.unKnownKeys = new HashSet<UDFContext.UDFContextKey>(this.allKeys);
            this.unKnownKeys.removeAll(this.knownKeys);
            for (Map.Entry<UDFContext.UDFContextKey, Properties> entry : this.udfContext.getUdfConfs().entrySet()) {
                if (!entry.getValue().isEmpty()) continue;
                this.unKnownKeys.remove(entry.getKey());
            }
        }
        return this.unKnownKeys;
    }

    public void setPlan(PhysicalPlan plan, String planOpKey) {
        this.mPlan = plan;
        this.dfw.setPlan(plan);
        this.mCurrentWalker = this.dfw;
        this.planOpKey = planOpKey;
        this.udfContextsPerPlan.put(planOpKey, new HashMap());
    }

    @Override
    public void visitUserFunc(POUserFunc userFunc) throws VisitorException {
        if (userFunc.getFunc() instanceof Algebraic) {
            for (UDFContext.UDFContextKey key : this.allKeys) {
                if (!key.getClassName().equals(userFunc.getFunc().getClass().getName())) continue;
                this.algebraicUDFKeys.add(key);
                this.knownKeys.add(key);
            }
        } else {
            this.findAndAddKeys(userFunc.getFunc().getClass().getName(), userFunc.getSignature(), UDFType.USERFUNC);
        }
    }

    @Override
    public void visitLoad(POLoad ld) throws VisitorException {
        this.findAndAddKeys(ld.getLoadFunc().getClass().getName(), ld.getSignature(), UDFType.LOADFUNC);
    }

    @Override
    public void visitStore(POStore st) throws VisitorException {
        this.findAndAddKeys(st.getStoreFunc().getClass().getName(), st.getSignature(), UDFType.STOREFUNC);
    }

    @Override
    public void visitCast(POCast op) {
        if (op.getFuncSpec() != null) {
            this.findAndAddKeys(op.getFuncSpec().getClass().getName(), null, UDFType.USERFUNC);
        }
    }

    private void findAndAddKeys(String keyClassName, String signature, UDFType udfType) {
        for (UDFContext.UDFContextKey key : this.allKeys) {
            if (!key.getClassName().equals(keyClassName) || key.getArgs() != null && signature != null && !Arrays.asList(key.getArgs()).contains(signature)) continue;
            Map<Enum<UDFType>, List<UDFContext.UDFContextKey>> udfKeysByType = this.udfContextsPerPlan.get(this.planOpKey);
            List<UDFContext.UDFContextKey> keyList = this.udfContextsPerPlan.get(this.planOpKey).get((Object)udfType);
            if (keyList == null) {
                keyList = new ArrayList<UDFContext.UDFContextKey>();
                udfKeysByType.put(udfType, keyList);
            }
            keyList.add(key);
            this.knownKeys.add(key);
        }
    }

    public void serializeUDFContext(Configuration conf, String planOpKey, UDFType ... udfTypes) throws IOException {
        HashMap<UDFContext.UDFContextKey, Properties> udfConfs = this.udfContext.getUdfConfs();
        HashMap<UDFContext.UDFContextKey, Properties> udfConfsToSerialize = new HashMap<UDFContext.UDFContextKey, Properties>();
        Map<Enum<UDFType>, List<UDFContext.UDFContextKey>> udfKeysByType = this.udfContextsPerPlan.get(planOpKey);
        if (udfKeysByType != null) {
            for (UDFType udfType : udfTypes) {
                List<UDFContext.UDFContextKey> keyList = this.udfContextsPerPlan.get(planOpKey).get((Object)udfType);
                if (keyList != null) {
                    for (UDFContext.UDFContextKey key : keyList) {
                        udfConfsToSerialize.put(key, (Properties)udfConfs.get(key));
                    }
                }
                if (!udfType.equals((Object)UDFType.USERFUNC)) continue;
                for (UDFContext.UDFContextKey key : this.algebraicUDFKeys) {
                    udfConfsToSerialize.put(key, (Properties)udfConfs.get(key));
                }
            }
        }
        this.serialize(conf, udfConfsToSerialize);
    }

    public void serializeUDFContext(Configuration conf, String planOpKey, POStore store) throws IOException {
        List<UDFContext.UDFContextKey> keyList;
        HashMap<UDFContext.UDFContextKey, Properties> udfConfs = this.udfContext.getUdfConfs();
        HashMap<UDFContext.UDFContextKey, Properties> udfConfsToSerialize = new HashMap<UDFContext.UDFContextKey, Properties>();
        Map<Enum<UDFType>, List<UDFContext.UDFContextKey>> udfKeysByType = this.udfContextsPerPlan.get(planOpKey);
        if (udfKeysByType != null && (keyList = this.udfContextsPerPlan.get(planOpKey).get((Object)UDFType.STOREFUNC)) != null) {
            String keyClassName = store.getStoreFunc().getClass().getName();
            String signature = store.getSignature();
            for (UDFContext.UDFContextKey key : keyList) {
                if (!key.getClassName().equals(keyClassName) || key.getArgs() != null && !Arrays.asList(key.getArgs()).contains(signature)) continue;
                udfConfsToSerialize.put(key, (Properties)udfConfs.get(key));
            }
        }
        this.serialize(conf, udfConfsToSerialize);
    }

    private void serialize(Configuration conf, HashMap<UDFContext.UDFContextKey, Properties> udfConfsToSerialize) throws IOException {
        HashMap<UDFContext.UDFContextKey, Properties> udfConfs = this.udfContext.getUdfConfs();
        Iterator<Map.Entry<UDFContext.UDFContextKey, Properties>> iter = udfConfsToSerialize.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<UDFContext.UDFContextKey, Properties> entry = iter.next();
            if (!entry.getValue().isEmpty()) continue;
            iter.remove();
        }
        for (UDFContext.UDFContextKey key : this.getUnKnownKeys()) {
            udfConfsToSerialize.put(key, udfConfs.get(key));
        }
        conf.set("pig.udf.context", ObjectSerializer.serialize(udfConfsToSerialize));
        conf.set("pig.client.sys.props", ObjectSerializer.serialize(this.udfContext.getClientSystemProps()));
    }

    public static enum UDFType {
        LOADFUNC,
        STOREFUNC,
        USERFUNC;

    }
}

