/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class LOJoin
extends LogicalRelationalOperator {
    private static final long serialVersionUID = 2L;
    private MultiMap<Integer, LogicalExpressionPlan> mJoinPlans;
    private boolean[] mInnerFlags;
    private JOINTYPE mJoinType;
    public static final Integer OPTION_JOIN = 1;

    public LOJoin(LogicalPlan plan) {
        super("LOJoin", plan);
    }

    public LOJoin(LogicalPlan plan, MultiMap<Integer, LogicalExpressionPlan> joinPlans, JOINTYPE jt, boolean[] isInner) {
        super("LOJoin", plan);
        this.mJoinPlans = joinPlans;
        this.mJoinType = jt;
        this.mInnerFlags = isInner;
    }

    public void setJoinPlans(MultiMap<Integer, LogicalExpressionPlan> joinPlans) {
        this.mJoinPlans = joinPlans;
    }

    public void setInnerFlags(boolean[] isInner) {
        this.mInnerFlags = isInner;
    }

    public void setJoinType(JOINTYPE jt) {
        this.mJoinType = jt;
    }

    public boolean isInner(int inputIndex) {
        return this.mInnerFlags[inputIndex];
    }

    public boolean[] getInnerFlags() {
        return this.mInnerFlags;
    }

    public JOINTYPE getJoinType() {
        return this.mJoinType;
    }

    public void resetJoinType() {
        this.mJoinType = JOINTYPE.HASH;
    }

    public Collection<LogicalExpressionPlan> getJoinPlan(int inputIndex) {
        return this.mJoinPlans.get(inputIndex);
    }

    public MultiMap<Integer, LogicalExpressionPlan> getExpressionPlans() {
        return this.mJoinPlans;
    }

    public Collection<LogicalExpressionPlan> getExpressionPlanValues() {
        return this.mJoinPlans.values();
    }

    @Override
    public LogicalSchema getSchema() throws FrontendException {
        if (this.schema != null) {
            return this.schema;
        }
        List<Operator> inputs = null;
        inputs = this.plan.getPredecessors(this);
        if (inputs == null) {
            return null;
        }
        ArrayList<LogicalSchema.LogicalFieldSchema> fss = new ArrayList<LogicalSchema.LogicalFieldSchema>();
        for (Operator op : inputs) {
            LogicalSchema inputSchema = ((LogicalRelationalOperator)op).getSchema();
            if (inputSchema == null) {
                this.schema = null;
                return this.schema;
            }
            for (int i = 0; i < inputSchema.size(); ++i) {
                LogicalSchema.LogicalFieldSchema fs = inputSchema.getField(i);
                LogicalSchema.LogicalFieldSchema newFS = null;
                newFS = fs.alias != null ? new LogicalSchema.LogicalFieldSchema(((LogicalRelationalOperator)op).getAlias() + "::" + fs.alias, fs.schema, fs.type, fs.uid) : new LogicalSchema.LogicalFieldSchema(fs.alias, fs.schema, fs.type, fs.uid);
                fss.add(newFS);
            }
        }
        this.schema = new LogicalSchema();
        for (LogicalSchema.LogicalFieldSchema fieldSchema : fss) {
            this.schema.addField(fieldSchema);
        }
        return this.schema;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2223);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof LOJoin) {
            LOJoin oj = (LOJoin)other;
            if (this.mJoinType != oj.mJoinType) {
                return false;
            }
            if (this.mInnerFlags.length != oj.mInnerFlags.length) {
                return false;
            }
            for (int i = 0; i < this.mInnerFlags.length; ++i) {
                if (this.mInnerFlags[i] == oj.mInnerFlags[i]) continue;
                return false;
            }
            if (!this.checkEquality(oj)) {
                return false;
            }
            if (this.mJoinPlans.size() != oj.mJoinPlans.size()) {
                return false;
            }
            for (Integer p : this.mJoinPlans.keySet()) {
                Iterator<Integer> iter = oj.mJoinPlans.keySet().iterator();
                int op = -1;
                while (iter.hasNext() && !p.equals(op = iter.next().intValue())) {
                }
                if (op != -1) {
                    List<LogicalExpressionPlan> c = this.mJoinPlans.get(p);
                    List<LogicalExpressionPlan> oc = oj.mJoinPlans.get(op);
                    if (c.size() != oc.size()) {
                        return false;
                    }
                    if (!(c instanceof List) || !(oc instanceof List)) {
                        throw new FrontendException("Expected list of expression plans", 2238);
                    }
                    List<LogicalExpressionPlan> elist = c;
                    List<LogicalExpressionPlan> oelist = oc;
                    for (int i = 0; i < elist.size(); ++i) {
                        if (elist.get(i).isEqual(oelist.get(i))) continue;
                        return false;
                    }
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name + "(" + this.mJoinType.toString() + ")";
    }

    public List<Operator> getInputs(LogicalPlan plan) {
        return plan.getPredecessors(this);
    }

    public static enum JOINTYPE {
        HASH,
        BLOOM,
        REPLICATED,
        SKEWED,
        MERGE,
        MERGESPARSE;

    }
}

