/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.util.HashSet;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.PlanValidationException;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LONative;
import org.apache.pig.newplan.logical.relational.LORank;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class SchemaAliasVisitor
extends LogicalRelationalNodesVisitor {
    public SchemaAliasVisitor(OperatorPlan plan) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
    }

    protected void validate(LogicalRelationalOperator op) throws FrontendException {
        LogicalSchema schema = op.getSchema();
        HashSet<String> seenAliases = new HashSet<String>();
        if (schema != null) {
            for (int i = 0; i < schema.size(); ++i) {
                if (schema.getField(i) == null || schema.getField((int)i).alias == null) continue;
                String alias = schema.getField((int)i).alias;
                if (seenAliases.contains(alias)) {
                    int errCode = 1108;
                    String msg = "Duplicate schema alias: " + schema.getField((int)i).alias;
                    if (op.getAlias() != null) {
                        msg = msg + " in \"" + op.getAlias() + "\"";
                    }
                    throw new PlanValidationException((Operator)op, msg, errCode, 2);
                }
                seenAliases.add(alias);
            }
        }
    }

    @Override
    public void visit(LOStore store) throws FrontendException {
        this.validate(store);
    }

    @Override
    public void visit(LOFilter filter) throws FrontendException {
        this.validate(filter);
    }

    @Override
    public void visit(LOJoin join) throws FrontendException {
        this.validate(join);
    }

    @Override
    public void visit(LOForEach foreach) throws FrontendException {
        new SchemaAliasVisitor(foreach.getInnerPlan()).visit();
    }

    @Override
    public void visit(LOGenerate gen) throws FrontendException {
        this.validate(gen);
    }

    @Override
    public void visit(LOInnerLoad load) throws FrontendException {
        this.validate(load);
    }

    @Override
    public void visit(LOCogroup group) throws FrontendException {
        this.validate(group);
    }

    @Override
    public void visit(LOSplit split) throws FrontendException {
        this.validate(split);
    }

    @Override
    public void visit(LOSplitOutput splitOutput) throws FrontendException {
        this.validate(splitOutput);
    }

    @Override
    public void visit(LOUnion union) throws FrontendException {
        this.validate(union);
    }

    @Override
    public void visit(LOSort sort) throws FrontendException {
        this.validate(sort);
    }

    @Override
    public void visit(LORank rank) throws FrontendException {
        this.validate(rank);
    }

    @Override
    public void visit(LODistinct distinct) throws FrontendException {
        this.validate(distinct);
    }

    @Override
    public void visit(LOLimit limit) throws FrontendException {
        this.validate(limit);
    }

    @Override
    public void visit(LOCross cross) throws FrontendException {
        this.validate(cross);
    }

    @Override
    public void visit(LOStream stream) throws FrontendException {
        this.validate(stream);
    }

    @Override
    public void visit(LONative nativeMR) throws FrontendException {
        this.validate(nativeMR);
    }
}

